#include "mbed.h"
#include "SDFileSystem.h"
//Nucleo L476RG_SDCARD test



/*              SD:                Description             nucleo           PINNR (from top to down of the right-connector-left pins):
                1                   CS                     PB_6              9  
                2                   MOSI                   PA_7              8
                3                   GND                    GND
                4                   3.3V                   3.3V
                5                   SCLK                   PA_5              6                  
                6                   -
                7                   MISO                   PA_6              7
                8
                
*/
//              MOSI, MISO, SCLK, CS, name
SDFileSystem sd(PA_7, PA_6, PA_5, PB_6, "sd");


int main() {
    printf("\nWait for new connection...\n");
    
    mkdir("/sd/mydir", 0777);
    printf("\nDirectory created\n");
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        printf("Could not open file for write\n");
    }
    fprintf(fp, "Hello fun SD Card World!");
    fclose(fp); 
    printf("Text written to the SD-CARD\n");
}
