#include "mbed.h"
/*
    Author Mariwan Jalal
    This function will take a string from the terminal and save it in a buffer.
    The string is editable during the time user input the string.
    This will be useful if any one want to have an interactive interface for an application.
    USE IT AT YOUR OWN RESPONSIBILITY .. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND
    Free to use.

*/

#define MAX_LENGTH_OF_THE_STRING   256                    //Change this line to get longer string.
#define   BAUD_RATE_              9600                    // Serial Terminal baudrate
Serial pc(USBTX, USBRX);

void GetStringFromSerial(char (& stringBuf) [MAX_LENGTH_OF_THE_STRING])
{
    pc.printf("Echoes back to the screen anything you type\n");
    int i=0;
    while(i<MAX_LENGTH_OF_THE_STRING) {
        stringBuf[i]=pc.getc();
        if(stringBuf[i]=='\n') {
            stringBuf[i]='\0';
            if (i>0) {
                i--;
                if(stringBuf[i]=='\r') {
                    stringBuf[i]='\0';
                }
                return;
            }
        }
        if(stringBuf[i]=='\b') {
            pc.puts("\b \b");
            stringBuf[i]='\0';
            if (i>0) {
                i--;
            }
            stringBuf[i]='\0';

        } else {
            pc.putc(stringBuf[i]);
            i++;
        }

    }
}

int main()
{
    pc.baud(BAUD_RATE_);   // DEFAULT IS 9600, THIS IS JUST FOR NOTIFICATION FOR THE READER.
    char g[MAX_LENGTH_OF_THE_STRING];
    memset (g,'\0',MAX_LENGTH_OF_THE_STRING);
    while (1) {
        memset (g,'\0',MAX_LENGTH_OF_THE_STRING);
        GetStringFromSerial(g);
        pc.printf("\n");
        pc.printf(g);
        pc.printf("\n");
    }
}