#include "mbed.h"
#include <math.h>
#include "InterruptManager.h"
#include "TPM_init.h"
#include "SLCD.h"
#define BAUD_RATE   9600

#define NVIC_ISER   0xE000E100
#define NVIC_ISPR   0xE000E200

#define SIM_SOPT2_ADDRESS 0x40048004
#define SIM_SCGC6_ADDRESS 0x4004803C


DigitalOut out(PTD3);
DigitalOut green(LED1);
DigitalOut red(LED2);
Serial pc(USBTX, USBRX);
Timer timer;
SLCD slcd;

unsigned int flag;
unsigned int modulo_val = 48000;
unsigned int prescale_val = 0;
volatile unsigned val = 10;
void TPM0_handler_test();

void init_test()
{
    NVIC_SetVector(TPM0_IRQn, (uint32_t) TPM0_handler_test);
    NVIC_SetPriority(TPM0_IRQn, 0);

    TPM0_init(modulo_val, prescale_val);

    NVIC_EnableIRQ(TPM0_IRQn);
    
    wait(5);
    TPM0_start();
}

void TPM0_handler_test() {
    unsigned int overflow = TPM0_SC_read() & 0x000000C0; 
    if(overflow == 0xC0) {
        TPM0_clear_overflow();
        NVIC_ClearPendingIRQ(TPM0_IRQn);
        flag++;
        if (flag == val) {
            out = !out;
            red = !red;
            flag = 0;
        }
//        green = !green;
    }
}

void read()
{
    char c = (char) pc.getc();
    green = !green;
    if (c == '1') {
        slcd.printf("%c",c);
        val = 1;
    } else if (c == '2') {
        slcd.printf("%c", c);
        val = 100;
    } else if (c == '3') {
        slcd.printf("%c",c);
        val = 1000;
    } else if (c == '4') {
        slcd.printf("%c",c);
        val = 10000;
    } else if (c == '5') {
        val = 100000;
    } else {
        slcd.printf("E");
        return;
    }
}

int main() {
    flag = 0;
    green = 0;
    red = 0;
    pc.baud(BAUD_RATE);
    pc.attach(read);
    slcd.printf("nesl");
    init_test();
    while(1) {
        if (flag == 1000) {
 //           green = !green;
            flag = 0;
        }
    }
/*
    while(1) {
        green = !green;
        out = !out;
        wait(0.5);
        out = !out;
        wait(0.5);
    }
*/
}
