#include "mbed.h"
#include "MMA8451Q.h"
#include "MAG3110.h"
#include "SLCD.h"
#include "TSISensor.h"

#define MMA8451_I2C_ADDRESS (0x1d << 1)
#define MAG3110_I2C_ADDRESS (0x0e << 1)

Serial pc(USBTX, USBRX);
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
MAG3110 mag(PTE25, PTE24, MAG3110_I2C_ADDRESS);
AnalogIn lightSensor(PTE22);
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
Timer t;
SLCD slcd;
TSISensor tsi;
float accel, magma, light, touch;

int main() {
        int a, m, l, t = 0, old = 0;
        t.reset();
        t.start();
        while (true){
            int time = t.read_ms();
            pc.printf(" time = %d",time);
            if (time/100 == 0){
                 accel = acc.getAccX();}
            if (time%170 == 0){
                 magma= mag.readVal(MAG_OUT_X_MSB);}
            if(time%250 == 0){
                 light = lightSensor.read();}
            if (time%320 == 0){
                 touch = tsi.readPercentage();}
            pc.printf(" acc = %f, mag = %f,light = %f,touch = %f\n", accel, magma, light, touch);
            }
    t.stop();
}