#include "mbed.h"
#define BAUD_RATE 921600
#define INITIATER 0

// http://mbed.org/platforms/FRDM-KL46Z/

DigitalOut myled(LED_GREEN);
Serial pc(USBTX, USBRX);
Serial uart(PTE0, PTE1);

char num = 0;

void receiver_send()
{
    while(1) {
        wait(1);
        uart.putc(num);
        num += 2;
        myled = !myled;
    }
}

void send(char c)
{
    uart.putc(c);
}

void read()
{
    myled = !myled;
    char c = uart.getc();
    num += 2;
//    send(num);
    if (INITIATER)
        pc.printf("%d\n", c);
}

int main() {    
    pc.baud(BAUD_RATE);
    uart.baud(BAUD_RATE);
    
    if (INITIATER) {
        uart.attach(read);
        num = 1;
        uart.putc(num);
    } else {
        num = 0;
        receiver_send();
    }
    
    pc.printf("Hello World\n");
    
    while (true) {
        wait(0.5);
    }
}