#include "mbed.h"
#include "MMA8451Q.h"
#include "MAG3110.h"
#include "TSISensor.h"

#define I2C0_SDA PTE25
#define I2C0_SCL PTE24
#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define MAG3110_I2C_ADDRESS (0x0E<<1)
#define LIGHT_SENSOR_PIN PTE22
#define COUNT 1000

Serial pc_sr(USBTX, USBRX);
MMA8451Q acc_sr(I2C0_SDA, I2C0_SCL, MMA8451_I2C_ADDRESS);
MAG3110 mag_sr(I2C0_SDA, I2C0_SCL, MAG3110_I2C_ADDRESS);
Timer timer_sr;
TSISensor tsi_sr;
AnalogIn lightSensor_sr(PTE22);

void light(int count)
{
    int i = 0;
    
    while (i < count) {
        lightSensor_sr.read();
        i++;
    }
}

void touch(int count)
{
    int i = 0;
    while(i < count) {
        tsi_sr.readPercentage();
        i++;
    }
}
    
void magnetometer(int count)
{
    int i = 0;
    
    while(i < count) {
       mag_sr.readVal(MAG_OUT_X_MSB);
       mag_sr.readVal(MAG_OUT_Y_MSB);
       mag_sr.readVal(MAG_OUT_Z_MSB);
       i++;
    }
}

void accelerometer(int count)
{
    int i = 0;
    
    while (i < 1000) {
        acc_sr.getAccX();
        acc_sr.getAccY();
        acc_sr.getAccZ();
        i++;
    }
}

void max_sample_rate(int count)
{
    int i = 0;
    
    while (i < count) {
        acc_sr.getAccX();
        acc_sr.getAccY();
        acc_sr.getAccZ();

        mag_sr.readVal(MAG_OUT_X_MSB);
        mag_sr.readVal(MAG_OUT_Y_MSB);
        mag_sr.readVal(MAG_OUT_Z_MSB);

        lightSensor_sr.read();
        
        tsi_sr.readPercentage();
        
        i++;
    }
}

int main() {
    int t1, t2;
    
//    while (true) {
    timer_sr.reset();
    
    // Accelerometer
    timer_sr.start();
    t1 = timer_sr.read_ms();
    accelerometer(COUNT);
    t2 = timer_sr.read_ms();
    timer_sr.stop();
    pc_sr.printf("Time to sample acceleromter sensor 1000times = %dms\n", t2 - t1);

    timer_sr.reset();
    
    // magnetometer
    timer_sr.start();
    t1 = timer_sr.read_ms();
    magnetometer(COUNT);
    t2 = timer_sr.read_ms();
    timer_sr.stop();
    pc_sr.printf("Time to sample magnetometer sensor 1000times = %dms\n", t2 - t1);

    timer_sr.reset();
    
    // light
    timer_sr.start();
    t1 = timer_sr.read_ms();
    light(COUNT);
    t2 = timer_sr.read_ms();
    timer_sr.stop();
    pc_sr.printf("Time to sample light sensor 1000times = %dms\n", t2 - t1);

    timer_sr.reset();
    
    // touch
    timer_sr.start();
    t1 = timer_sr.read_ms();
    touch(COUNT);
    t2 = timer_sr.read_ms();
    timer_sr.stop();
    pc_sr.printf("Time to sample touch sensor 1000times = %dms\n", t2 - t1);
    
    timer_sr.reset();
    
    // All
    timer_sr.start();
    t1 = timer_sr.read_ms();
    max_sample_rate(COUNT);
    t2 = timer_sr.read_ms();
    timer_sr.stop();
    pc_sr.printf("Time to sample all sensors 1000times = %dms\n", t2 - t1);
    wait(1);
//    }

}