#include "mbed.h"
#include "AnalogOut.h"
#include "AnalogIn.h"
#include <math.h>

#define I2C0_SDA PTE25
#define I2C0_SCL PTE24
#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define MAG3110_I2C_ADDRESS (0x0E<<1)
#define LIGHT_SENSOR_PIN PTE22
#define PI 3.141f

Serial pc_sine(USBTX, USBRX);
Timer timer;


void sine_wave()
{
    int t = 0;
    float s;
    AnalogOut a(PTE30);
    while (1) { // sin(2 * PI * f * t / Fs)
        s = sin(2 * PI * 1 * t / 100.0);
        s = s/2 + .5;
        a.write(s);
        pc_sine.printf ("%f\n", s);
        if (t == 100)
            t = 0;
        else
            t++;
        wait(0.01);
    }
}

void sine_wave_read()
{
    AnalogIn a(PTB0);
    while(1) {
        pc_sine.printf("%f\n", a.read());
        wait(0.01);
    }
}


int main() {
    sine_wave();

    char c = pc_sine.getc();
    
    switch (c) {
        case '1':sine_wave();
            break;
        case '2': sine_wave_read();
            break;
    }
}
