#include "mbed.h"
#include "MMA8451Q.h"
#include "MAG3110.h"
#include "SLCD.h"
#include "TSISensor.h"

#define MAX_TIME 10
#define BAUD_RATE 230400 //115200
#define MMA8451_I2C_ADDRESS (0x1d << 1)
#define MAG3110_I2C_ADDRESS (0x0e << 1)
    
Serial pc(USBTX, USBRX);
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
MAG3110 mag(PTE25, PTE24, MAG3110_I2C_ADDRESS);
AnalogIn lightSensor(PTE22);
DigitalOut green(LED1);
DigitalOut red(LED2);
Timer tt;
Timer epoch;
SLCD slcd;
TSISensor tsi;

/*
    Sensortype:
    'a' - accelerometer
    'b' - maganetometer
    'c' - light
    'd' - touch
    
    rate: 0:1:100 (min sampling period =10ms)
    rate = 0 => sensor switched off
*/
int i = 0;
char input[10]; // sensorType, 3bytes - rate, 'z'
int aval=0, mval=0, lval=0, tval=0;
int a=aval, m=mval, l=lval, t = tval;
bool facc = true, fmag = true, flight = true, ftouch = true;

void transform()
{
    int j, val = 0;
    
    for (j = 1; j < 4; j++) {
        val = val * 10 + (input[j] - '0');
    }

    switch (input[0]) {
        case 'a':
            a = 0;
            if (val == 0)
                facc = false;
            else {
                facc = true;
                aval = val - 1;
            }
            break;
        case 'b':
            m = 0;
            if (val == 0)
                fmag = false;
            else {
                fmag = true;
                mval = val - 1;
            }
            break;
        case 'c': 
            l = 0;
            if (val == 0)
                flight = false;
            else {
                flight = true;
                lval = val - 1;
            }
            break;
        case 'd': 
            t = 0;
            if (val == 0)
                ftouch = false;
            else {
                ftouch = true;
                tval = val - 1;
            }
            break;
    }
    for (j = 0; j < 5; j++)
        input[j] = 'k';
}

void read()
{
    char c = (char) pc.getc();

    if (c >= 'a' && c <= 'd')
        slcd.printf("%c", c);
    else if (c == 'z')
        slcd.printf("%c",'n');
    else if (c >= '0' && c <= '9')
        slcd.printf("%c", c);
    else
        slcd.printf("%c", 'E');
    if (i == 0 && c >= 'a' && c <= 'd') {
            input[i++] = c;
    } else if (i >= 1 && i <= 3 && c >= '0' && c <= '9') {
            input[i++] = c;
    } else if (i == 4 && c == 'z') {
        transform();
        i = 0;
    } else {
        i = 0;
        red = !red;
        for (int j = 0; j < 5; j++) {
            input[j] = 'k';
        }
    }
}

int main()
{
    float acce1, acce2, acce3, magma1, magma2, magma3, light, touch;
    pc.baud(BAUD_RATE);
    pc.attach(read);

    epoch.start();
    while(true) {    
        tt.reset();
        red = 1;
        green = 0;
        wait(0.2);
        red = 0;
        green = 1;
        wait(0.2);

        tt.start();
        float time_elapsed = epoch.read();
        int time = tt.read_ms();
        if (facc) {
            if (a == 0){
                 acce1 = acc.getAccX();
                 acce2 = acc.getAccY();
                 acce3 = acc.getAccZ();
                 pc.printf("a=%f,%f,%f,z%f\n", acce1, acce2, acce3, time_elapsed);
                 a = aval;
            } else
                a--;
        }
        if (fmag) {
            if (m == 0){
                magma1 = mag.readVal(MAG_OUT_X_MSB);
                magma2 = mag.readVal(MAG_OUT_Y_MSB);
                magma3 = mag.readVal(MAG_OUT_Z_MSB);
                pc.printf("m=%f,%f,%f,z%f\n", magma1, magma2, magma3, time_elapsed);
                m =mval;
            } else
                m--;
        }
        if (flight) {
            if(l == 0){
                light = lightSensor.read();
                pc.printf("l=%f,z%f\n", light, time_elapsed);
                l=lval;
            } else
                l--;
        }
        if (ftouch) {
            if (t == 0){
                touch = tsi.readPercentage();
                pc.printf("t=%f,z%f\n", touch, time_elapsed);
                t= tval;
            } else
                t--;
        }
        int time1 = tt.read_ms();
        tt.stop();
//        pc.printf("tt:%d\n", time1-time);
        if(MAX_TIME < time1-time)
            ;
        else
            wait((MAX_TIME-(time1-time))/1000.0);
    }
}