#include "mbed.h"
#include "BufferedSerial.h"

BufferedSerial pc(USBTX, USBRX);
BufferedSerial uart3(PTC17, PTC16);

int main() {
    pc.puts("\r\nscissors\r\n");
    
    uart3.baud(115200);
    uart3.format(8, Serial::None, 1>>1);

    while (true) {
        if (pc.readable()) {
            char c = pc.getc();
            uart3.putc(c);
        }
        while (uart3.readable()) {
            char d = uart3.getc();
            pc.putc(d);
        }
    }
}
