/*
Suga Koubou 製 PS_PADライブラリ https://developer.mbed.org/users/okini3939/code/PS_PAD/
を改造して作成。といっても__rbitをビット順序反転の関数に変えただけだけど…
ちなみに使うボードのSPIが250kHzに対応していないと使えない。
動作確認済みのボード
使えないボード
nucleo F411
使えるボード
LPC1114
*/

//CLIからupdateするのに対応しているのかを確認したいのでここに一文追加してみたよ！

#include "mbed.h"
#include "PS_PAD.h"

//PS_PAD vsc3(dp2, dp1, dp6, dp13);
SPI spi(dp2, dp1, dp6);
PS_PAD vsc3(spi, dp13);
Serial pc(dp16, dp15);

int val;
int rx, ry;

int main() {
    pc.baud(9600);
    pc.printf("Reset\r\n");

    val = vsc3.init();
    if (val == -1 ) {
        pc.printf ("Failure\n");
    }else if (val == 0) {
        pc.printf("START\n");
    }

    while() {
        vsc3.poll();
        if (vsc3.read(PS_PAD::PAD_CIRCLE) == 1) pc.printf("CIRCLE\n");
        if (vsc3.read(PS_PAD::PAD_SQUARE) == 1) pc.printf("SQUARE\n");
        if (vsc3.read(PS_PAD::PAD_TRIANGLE) == 1) pc.printf("TRIANGLE\n");
        if (vsc3.read(PS_PAD::PAD_X) == 1) pc.printf("X\n");
        rx = vsc3.read(PS_PAD::ANALOG_RX); ry = vsc3.read(PS_PAD::ANALOG_RY);
        pc.printf("Right X = %d Y = %d\r\n", rx, ry);
        wait(0.05);
    }
}
