#include "mbed-trace/mbed_trace.h"
#define TRACE_GROUP "MAIN"

#include "mbed.h"
//#include "ESP8266Interface.h"

DigitalOut myled(PB_3) ;
Serial pc (PA_2, PA_15, 115200) ;
//DigitalOut myled(PA_5) ;
//Serial pc (PA_2, PA_3, 115200) ;
PwmOut mt[2][2] = {{PA_3, PA_6}, {PA_9, PA_8}} ;
WiFiInterface *wifi ;

Mutex smutex ;

Thread t_led(osPriorityLow) ;
//Thread t_serial(osPriorityAboveNormal) ; //configure mutex lock

void thread_led() ;
//void thread_serial() ;
void move_motor(float*) ;
const char *sec2str(nsapi_security_t sec) ;

static void mutex_wait() ;
static void mutex_release() ;


static void mutex_wait(){
    smutex.lock() ;
}
static void mutex_release(){
    smutex.unlock() ;
}

void thread_led(){
    while( true ) {
        myled = 1 ;
        wait(0.1) ;
        myled = 0 ;
        wait(1.0) ;
    }
}

/*

void thread_serial(){
    pc.printf("Reset\r\n") ;
    pc.printf("Start Moving\r\n") ;
    pc.printf("Command\r\n") ;
    pc.printf("w:Forward, s:Backward\r\n") ;
    pc.printf("a:Left, d:Right\r\n") ;
    pc.printf("x:Stop\r\n") ;
    
    float motor[2] = {0.0, 0.0} ;
    
    while( true ){
        if ( pc.readable() ){
            char command ;
            command = pc.getc() ;
            switch ( command ) {
                case 'w' :
                    motor[0] = 0.5 ;
                    motor[1] = 0.5 ;
                    break ;
                case 's' :
                    motor[0] = -0.5 ;
                    motor[1] = -0.5 ;
                    break ;
                case 'a' :
                    motor[0] = 0.7 ;
                    motor[1] = -0.7 ;
                    break ;
                case 'd' :
                    motor[0] = -0.7 ;
                    motor[1] = 0.7 ;
                    break ;
                case 'x' :
                    motor[0] = 0.0 ;
                    motor[1] = 0.0 ;
                    break ;
                default :
                    break ;
            }
            pc.putc(command) ;
            move_motor(motor) ;
        }
        wait(0.05) ;
    }
}*/

void move_motor(float* _motor){
    int i ;
    for ( i = 0 ; i < 2 ; i++ ){
        if ( _motor[i] > 0.01f ){
           mt[i][0] = _motor[i] ;
            mt[i][1] = 0.0 ;
        } else if ( _motor[i] < -0.01f ) {
            mt[i][0] = 0.0 ;
            mt[i][1] = ( _motor[i] * -1.f ) ;
        } else {
            mt[i][0] = 0.0 ;
            mt[i][1] = 0.0 ;
        }
    }
}

const char *sec2str(nsapi_security_t sec){
    switch (sec) {
        case NSAPI_SECURITY_NONE:
            return "None";
        case NSAPI_SECURITY_WEP:
            return "WEP";
        case NSAPI_SECURITY_WPA:
            return "WPA";
        case NSAPI_SECURITY_WPA2:
            return "WPA2";
        case NSAPI_SECURITY_WPA_WPA2:
            return "WPA/WPA2";
        case NSAPI_SECURITY_UNKNOWN:
        default:
            return "Unknown";
    }
}

void http_demo(NetworkInterface *net)
{
    TCPSocket socket;
    nsapi_error_t response;
    smutex.lock() ;
    pc.printf("Sending HTTP request to www.arm.com...\n");
    smutex.unlock() ;

    // Open a socket on the network interface, and create a TCP connection to www.arm.com
    response = socket.open(net);
    if(0 != response) {
        smutex.lock() ;
        pc.printf("socket.open() failed: %d\n", response);
        smutex.unlock() ;
        return;
    }

    response = socket.connect("api.ipify.org", 80);
    //const char ip_addr_ipify[4] = {23,21,121,219} ;
    //SocketAddress addr(ip_addr_ipify, 80) ;
    //response = socket.connect(addr);
    if(0 != response) {
        smutex.lock() ;
        pc.printf("Error connecting: %d\n", response);
        smutex.unlock() ;
        socket.close();
        return;
    }

    // Send a simple http request
    char sbuffer[] = "GET / HTTP/1.1\r\nHost: api.ipify.org\r\nConnection: close\r\n\r\n";
    nsapi_size_t size = strlen(sbuffer);

    // Loop until whole request send
    while(size) {
        response = socket.send(sbuffer+response, size);
        if (response < 0) {
            smutex.lock() ;
            pc.printf("Error sending data: %d\n", response);
            smutex.unlock() ;
            socket.close();
            return;
        }
        size -= response;
        smutex.lock() ;
        pc.printf("sent %d [%.*s]\n", response, strstr(sbuffer, "\r\n")-sbuffer, sbuffer);
        smutex.unlock() ;
    }

    // Receieve a simple http response and print out the response line
    char rbuffer[64];
    response = socket.recv(rbuffer, sizeof rbuffer);
    if (response < 0) {
        smutex.lock() ;
        pc.printf("Error receiving data: %d\n", response);
        smutex.unlock() ;
    } else {
        smutex.lock() ;
        pc.printf("recv %d [%.*s]\n", response, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);
        smutex.unlock() ;
    }

    // Close the socket to return its memory and bring down the network interface
    socket.close();
}

int main() {
    mbed_trace_mutex_wait_function_set( mutex_wait ) ;
    mbed_trace_mutex_release_function_set( mutex_release ) ;
    mbed_trace_init() ;
    int i, j ;
    for ( i = 0 ; i < 2 ; i++ ){
        for ( j = 0 ; j < 2 ; j++ ){
            mt[i][j].period(0.00002) ;
        }
    }
    t_led.start(thread_led) ;
    //t_serial.start(thread_serial) ;
    smutex.lock() ;
    pc.printf("Helloworld\r\n") ;
    smutex.unlock() ;
    wait(2.0) ;
    smutex.lock() ;
    pc.printf("WiFi example\r\n");
    smutex.unlock() ;

    wifi = WiFiInterface::get_default_instance();
    if (!wifi) {
        smutex.lock() ;
        pc.printf("ERROR: No WiFiInterface found.\r\n");
        smutex.unlock() ;
        return -1;
    }
    
    WiFiAccessPoint *ap ;
    
    smutex.lock() ;
    pc.printf("Scan:\r\n");
    smutex.unlock() ;
    int count = wifi->scan(NULL,0);
    if ( count <= 0 ) {
        smutex.lock() ;
        pc.printf("scan failed with return value, %d\r\n", count) ;
        smutex.unlock() ;
        return 0 ;
    }
    smutex.lock() ;
    pc.printf("scan end, %d access point founded\r\n",count) ;
    smutex.unlock() ;
    
    smutex.lock() ;
    pc.printf("Scaning All APs...\r\n");
    smutex.unlock() ;
    ap = new WiFiAccessPoint[count];
    count = wifi->scan(ap, count);
    for (int i = 0; i < count; i++) {
        smutex.lock() ;
        pc.printf("Network: %s secured: %s BSSID: %hhX:%hhX:%hhX:%hhx:%hhx:%hhx RSSI: %hhd Ch: %hhd\r\n", ap[i].get_ssid(),
               sec2str(ap[i].get_security()), ap[i].get_bssid()[0], ap[i].get_bssid()[1], ap[i].get_bssid()[2],
               ap[i].get_bssid()[3], ap[i].get_bssid()[4], ap[i].get_bssid()[5], ap[i].get_rssi(), ap[i].get_channel());
        smutex.unlock() ;
    }
    smutex.lock() ;
    pc.printf("%d networks available.\r\n", count);
    smutex.unlock() ;
    
    smutex.lock() ;
    pc.printf("Connecting...") ;
    smutex.unlock() ;
    int val = wifi->connect("Buffalo-G-C1B0", "hp43hgw57hhxe", NSAPI_SECURITY_WPA2);
    //int val = wifi->connect("KOUSUKE-PC_6698", "67eT0013", NSAPI_SECURITY_WPA2) ;
    if (val != 0) {
        smutex.lock() ;
        pc.printf("ERROR: No WiFiInterface found.\r\n");
        smutex.unlock() ;
        return -1;
    }
    pc.printf("Connection Result::%d\r\n", val) ;
    pc.printf("MAC: %s\r\n", wifi->get_mac_address());
    pc.printf("IP: %s\r\n", wifi->get_ip_address());
    pc.printf("Netmask: %s\r\n", wifi->get_netmask());
    pc.printf("Gateway: %s\r\n", wifi->get_gateway());
    pc.printf("RSSI: %d\r\n\n", wifi->get_rssi());
    
    http_demo(wifi) ;
    
    smutex.lock() ;
    pc.printf("Finished\r\n");
    smutex.unlock() ;
    
    wait(osWaitForever) ;
}