#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "HTTPClient.h"
#include "RPCFunction.h" 

DigitalOut led1(LED1,"led1");
DigitalOut led2(LED2,"led2");
DigitalOut led3(LED3,"led3");
DigitalOut led4(LED4,"led4");


#if 1
/*
 * Use DHCP
 */
        EthernetNetIf ethif;
#else
/*
 * Use "static IP address" (Parameters:IP, Subnet mask, Gateway, DNS)
 */
        EthernetNetIf ethif(IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx));
#endif
    
    HTTPServer server;
    LocalFileSystem local("local");

    void LedWink(char *input,char *output);
    RPCFunction rpcFunc(&LedWink, "LedWink");


int main(void) {

    Base::add_rpc_class<DigitalOut>();

    if (ethif.setup()) {
        error("Ethernet setup failed.");
        return 1;
    }
    IpAddr ethIp=ethif.getIp();
    
    led1=1; //confirm Eathernet working
    server.addHandler<RPCHandler>("/rpc");
    FSHandler::mount("/local", "/");
    server.addHandler<FSHandler>("/");
    server.bind(80);
    
    while (1) {
        Net::poll();
    }
    return 0;
}

void LedWink(char *input, char *output){
    int i;
    for(i=0;i<8;i++){
        led4=!led4;
        wait(0.2);
    }
    return;   
}