#include "mbed.h"
        
        
/* Display Resultion (128x160) */
#include "DisplayN18.h" 
DisplayN18 disp;
char width = 160, height = 128;


/* Graphic Units */
// Draw Blank Unit (13x10)
void DrawBlankUnit(int Dx,int Dy)
{
    for(int y=-5;y<16;y++) 
    for(int x=0;x<8;x++) 
    disp.setPixel(Dy+y,Dx+x,0x0000);
}

// Enemies Visibility and Coordinates
bool EnemyVisible[3][5];
/* {
    {true,true,true,true,true},
    {true,true,true,true,true},
    {true,true,true,true,true}
}; */
bool FireBullet = false; // Fire Bullet

int EnemyCol[3][5] = {
    {10,30,50,70,90},
    {10,30,50,70,90},
    {10,30,50,70,90}
};
int EnemyRow[3][5] = {
    {10,10,10,10,10},
    {20,20,20,20,20},
    {30,30,30,30,30}
};
// Enemy Unit Part 1
unsigned short Enemy1[8][11] = 
{
        {0x0000,0x0000,0x0000,0xffff,0x0000,0x0000,0x0000,0xffff,0x0000,0x0000,0x0000},
        {0xffff,0x0000,0x0000,0xffff,0x0000,0x0000,0x0000,0xffff,0x0000,0x0000,0xffff},
        {0xffff,0x0000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0000,0xffff},
        {0xffff,0xffff,0xffff,0x0000,0xffff,0xffff,0xffff,0x0000,0xffff,0xffff,0xffff},
        {0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
        {0x0000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0000},
        {0x0000,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0xffff,0x0000,0x0000},
        {0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffff,0x0000},        
};
//  Enemy Unit Part 2
unsigned short Enemy2[8][11] = 
{
        {0x0000,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0xffff,0x0000,0x0000},
        {0x0000,0x0000,0x0000,0xffff,0x0000,0x0000,0x0000,0xffff,0x0000,0x0000,0x0000},
        {0x0000,0x0000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0000,0x0000},
        {0x0000,0xffff,0xffff,0x0000,0xffff,0xffff,0xffff,0x0000,0xffff,0xffff,0x0000},
        {0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
        {0xffff,0x0000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0000,0xffff},
        {0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0xffff,0x0000,0xffff},
        {0x0000,0x0000,0x0000,0xffff,0xffff,0x0000,0xffff,0xffff,0x0000,0x0000,0x0000}        
};
// Draw Enemy Unit Part 1
void DrawEnemyUnitPart1(int Dx,int Dy)
{
    DrawBlankUnit(Dx,Dy);
    for(int y=0;y<11;y++) 
    for(int x=0;x<8;x++) 
    if(Enemy1[x][y] != 0x0000)
    disp.setPixel(Dy+y,Dx+x,Enemy1[x][y]);
}
// Draw Enemy Unit Part 2
void DrawEnemyUnitPart2(int Dx,int Dy)
{
    DrawBlankUnit(Dx,Dy);
    for(int y=0;y<11;y++) 
    for(int x=0;x<8;x++) 
    if(Enemy2[x][y] != 0x0000)
    disp.setPixel(Dy+y,Dx+x,Enemy2[x][y]);
}
// Draw All Visible Enemies
void DrawEnemies(int y,int x)
{    
     // part 1
    if(EnemyVisible[0][0]) DrawEnemyUnitPart1(EnemyRow[0][0]+y,EnemyCol[0][0]+x);
    if(EnemyVisible[0][1]) DrawEnemyUnitPart1(EnemyRow[0][1]+y,EnemyCol[0][1]+x);
    if(EnemyVisible[0][2]) DrawEnemyUnitPart1(EnemyRow[0][2]+y,EnemyCol[0][2]+x);
    if(EnemyVisible[0][3]) DrawEnemyUnitPart1(EnemyRow[0][3]+y,EnemyCol[0][3]+x);
    if(EnemyVisible[0][4]) DrawEnemyUnitPart1(EnemyRow[0][4]+y,EnemyCol[0][4]+x);    
    if(EnemyVisible[1][0]) DrawEnemyUnitPart1(EnemyRow[1][0]+y,EnemyCol[1][0]+x);
    if(EnemyVisible[1][1]) DrawEnemyUnitPart1(EnemyRow[1][1]+y,EnemyCol[1][1]+x);
    if(EnemyVisible[1][2]) DrawEnemyUnitPart1(EnemyRow[1][2]+y,EnemyCol[1][2]+x);
    if(EnemyVisible[1][3]) DrawEnemyUnitPart1(EnemyRow[1][3]+y,EnemyCol[1][3]+x);
    if(EnemyVisible[1][4]) DrawEnemyUnitPart1(EnemyRow[1][4]+y,EnemyCol[1][4]+x);    
    if(EnemyVisible[2][0]) DrawEnemyUnitPart1(EnemyRow[2][0]+y,EnemyCol[2][0]+x);
    if(EnemyVisible[2][1]) DrawEnemyUnitPart1(EnemyRow[2][1]+y,EnemyCol[2][1]+x);
    if(EnemyVisible[2][2]) DrawEnemyUnitPart1(EnemyRow[2][2]+y,EnemyCol[2][2]+x);
    if(EnemyVisible[2][3]) DrawEnemyUnitPart1(EnemyRow[2][3]+y,EnemyCol[2][3]+x);
    if(EnemyVisible[2][4]) DrawEnemyUnitPart1(EnemyRow[2][4]+y,EnemyCol[2][4]+x);    
    // part 2
    if(EnemyVisible[0][0]) DrawEnemyUnitPart2(EnemyRow[0][0]+y,EnemyCol[0][0]+x);
    if(EnemyVisible[0][1]) DrawEnemyUnitPart2(EnemyRow[0][1]+y,EnemyCol[0][1]+x);
    if(EnemyVisible[0][2]) DrawEnemyUnitPart2(EnemyRow[0][2]+y,EnemyCol[0][2]+x);
    if(EnemyVisible[0][3]) DrawEnemyUnitPart2(EnemyRow[0][3]+y,EnemyCol[0][3]+x);
    if(EnemyVisible[0][4]) DrawEnemyUnitPart2(EnemyRow[0][4]+y,EnemyCol[0][4]+x);    
    if(EnemyVisible[1][0]) DrawEnemyUnitPart2(EnemyRow[1][0]+y,EnemyCol[1][0]+x);
    if(EnemyVisible[1][1]) DrawEnemyUnitPart2(EnemyRow[1][1]+y,EnemyCol[1][1]+x);
    if(EnemyVisible[1][2]) DrawEnemyUnitPart2(EnemyRow[1][2]+y,EnemyCol[1][2]+x);
    if(EnemyVisible[1][3]) DrawEnemyUnitPart2(EnemyRow[1][3]+y,EnemyCol[1][3]+x);
    if(EnemyVisible[1][4]) DrawEnemyUnitPart2(EnemyRow[1][4]+y,EnemyCol[1][4]+x);    
    if(EnemyVisible[2][0]) DrawEnemyUnitPart2(EnemyRow[2][0]+y,EnemyCol[2][0]+x);
    if(EnemyVisible[2][1]) DrawEnemyUnitPart2(EnemyRow[2][1]+y,EnemyCol[2][1]+x);
    if(EnemyVisible[2][2]) DrawEnemyUnitPart2(EnemyRow[2][2]+y,EnemyCol[2][2]+x);
    if(EnemyVisible[2][3]) DrawEnemyUnitPart2(EnemyRow[2][3]+y,EnemyCol[2][3]+x);
    if(EnemyVisible[2][4]) DrawEnemyUnitPart2(EnemyRow[2][4]+y,EnemyCol[2][4]+x);  
    // wait(0.01); // timeout
}
// Check Enemy Kill
void EnemyKill(int By,int Bx,int Ey,int Ex)
{
    for(int row=0;row<3;row++)
    for(int col=0;col<5;col++)
    if( EnemyVisible[row][col] == true and
        By >= EnemyRow[row][col]+Ey and By <= EnemyRow[row][col]+Ey+8 and 
        Bx >= EnemyCol[row][col]+Ex and Bx <= EnemyCol[row][col]+Ex+11 
    )
    {        
        disp.setPixel(Bx,By,0x0000); // hide current bullet
        FireBullet = false; // enable next bullet
        EnemyVisible[row][col] = false; // disable killed enemy
        DrawBlankUnit(EnemyRow[row][col]+Ey,EnemyCol[row][col]+Ex); // hide killed enemy                    
    }
}

// Player Graphics
unsigned short Player[8][11] = 
{
        {0x0000,0x0000,0x0000,0x0000,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000},
        {0x0000,0x0000,0x0000,0x0000,0xffff,0xffff,0xffff,0x0000,0x0000,0x0000,0x0000},
        {0x0000,0x0000,0x0000,0x0000,0xffff,0xffff,0xffff,0x0000,0x0000,0x0000,0x0000},
        {0x0000,0x0000,0x0000,0x0000,0xffff,0xffff,0xffff,0x0000,0x0000,0x0000,0x0000},
        {0x0000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0000},
        {0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
        {0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
        {0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
        
};
// Draw Player
void DrawPlayer(int Dx,int Dy)
{
    DrawBlankUnit(Dx,Dy);
    for(int y=0;y<11;y++) 
    for(int x=0;x<8;x++) 
    if(Player[x][y] != 0x0000)
    disp.setPixel(Dy+y,Dx+x,Player[x][y]);
}

/* Keyboard */
DigitalIn LeftButton(P0_14, PullUp);
DigitalIn RightButton(P0_11, PullUp);
DigitalIn FireButton(P0_1, PullUp);
// DigitalIn FireButton(P0_16, PullUp);
char LEFT = 0, RIGHT = 1, UP = 2, DOWN = 3;

/* Dispplay Splash Screen */
void DisplaySplashScreen()
{
    char* info[5] = 
    {
        "Burgas Game Jam 2015",
        "Space Inviders Replica",
        "by Dimitar Minchev",
        "PhD of Informatics",
        "Press Fire to Start ..."
    };
    // info
    disp.drawString(10, 10, info[0], 0xffff, 0x0000, 1);   
    disp.drawString(10, 30, info[1], 0xffff, 0x0000, 1);
    disp.drawString(10, 50, info[2], 0xffff, 0x0000, 1);  
    disp.drawString(10, 70, info[3], 0xffff, 0x0000, 1);       
    disp.drawString(10, 90, info[4], 0xffff, 0x0000, 1); 
    // wait keypress
    while (FireButton) wait_ms(1);        
    disp.clear();
}
// YouWin
void DisplayYouWin()
{
    disp.clear();
    disp.drawString(10, 50, "You Win", 0xffff, 0x0000, 2);  
    while(true) wait_ms(1); // forever until restart
}
// GameOver
void DisplayGameOver()
{
    disp.clear();
    disp.drawString(10, 50, "Game Over", 0xffff, 0x0000, 2);  
    while(true) wait_ms(1); // forever until restart
}


// Main function
main()
{
    // Start
    DisplaySplashScreen();
    
    // vars
    bool MoveRight = true;   // Movement Direction 
    int Ex = 0,  Ey = 0;     // Enemies Coordinates 
    int Px = 75, Py = 120;   // Player Coordinates
    int Bx = 80, By = 120;   // Bullet Coordinates    
    
    // Initialize Emeny Visibility
    for(int row=0;row<3;row++) for(int col=0;col<5;col++) EnemyVisible[row][col] = true;    
    
    // the loop
    while (true) 
    {       
        // Buttons     
        int LeftButtonState = LeftButton.read();
        if( LeftButtonState == 0 ) Px -= 5;
        int RightButtonState = RightButton.read();
        if( RightButtonState == 0 ) Px += 5;        
        int FireButtonState = FireButton.read();
        if(FireButtonState == 0 && FireBullet == false) 
        {
             Bx = Px + 5;
             By = Py;
             FireBullet = true;
        }
                        
        // Draw Enemies
        DrawEnemies(Ey,Ex);
        
        // Draw Player   
        DrawPlayer(Py,Px);
    
        // Bullet Movement       
        if(FireBullet) 
        {            
            disp.setPixel(Bx,By,0x0000);
            By = By - 5;
            disp.setPixel(Bx,By,0xffff);
        }
        if(By <= 10) // Remove bulet if it is outside 
        { 
            disp.setPixel(Bx,By,0x0000);
            By = Py;
            FireBullet = false;
        }
        
        // Check if bullet hit enemy
        if(FireBullet) EnemyKill(By,Bx,Ey,Ex);
        
        // Enemies Movement
        if(Ex>=60 || Ex<=-6)
        {
            for(int row=10;row<=30;row+=10)
            for(int col=10;col<=90;col+=20)
            DrawBlankUnit(row+Ey,col+Ex);
            Ey += 10;   
        }
        if(Ex>=60) MoveRight = false;    
        if(Ex<=-6) MoveRight = true;          
        if(MoveRight) Ex++;
        else Ex--;
        
        // Check Win or Lose
        bool win = true;
        for(int row=0;row<3;row++) for(int col=0;col<5;col++) if(EnemyVisible[row][col] == true) win = false;
        if(win) DisplayYouWin();
        if(Ey >= 120) DisplayGameOver();
    }    
}
