#include "mbed.h"
#include "max6675.h"
#include "max6675_2.h"
#include "SDFileSystem.h"
#include <time.h>
#include <stdio.h>
 
DigitalOut led_1(LED1);
DigitalOut led_2(LED2);
DigitalOut led_3(LED3);
DigitalOut led_4(LED4);
SPI spi(p11,p12,p13);
max6675 max(spi,p18);
SPI spi_2(p11,p12,p13);
max6675_2 max_2(spi_2,p21);
AnalogIn LM61(p15);
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
Serial pc(USBTX,USBRX);
DigitalIn swi_1(p23);   //p5～p30のどれでも良い
DigitalIn swi_2(p22);   //p5～p30のどれでも良い

void led()
{
   led_1 = 1;
   led_2 = 1;
   led_3 = 1;
   led_4 = 1;
   wait(.2);
   
   led_1 = 0;
   led_2 = 0;
   led_3 = 0;
   led_4 = 0;
   wait(.2);
   
   led_1 = 1;
   led_2 = 1;
   led_3 = 1;
   led_4 = 1;
   wait(.2);
   
   led_1 = 0;
   led_2 = 0;
   led_3 = 0;
   led_4 = 0;
   wait(.2);
}
 
int main() 
{  
   int r = 9;  //平均する値の個数
   double w_h = .42; //加熱waitの時間
   double w_c = .417; //冷却waitの時間
   clock_t start_h;
   clock_t start_c;
   float tempC, sum, sum_2, ave, ave_2;
   int i, j;   //平均化処理に使用
   swi_1.mode(PullUp);
   swi_2.mode(PullUp);
    
   mkdir("/sd/mydir", 0777);
   printf("test start!\n");
   
  
   if( swi_1 == 1 && swi_2 == 0 )  //スイッチをマイコン側に倒したとき
     {
       printf("\n\n\nheating start\n\n\n");
      
       led();
       
       while (1)
        {
           start_h = clock();
             printf("%f\n", (double)start_h/CLOCKS_PER_SEC);
           
            max.select();                       
            max_2.deselect_2();
 
          //平均化処理      
          
            sum = 0;
            ave = 0;
            i = 0;
           for( i = 0; i < r; i++)            
             {
              float temp = max.read_temp();
              sum += temp;
             }   
            
            ave = sum / r;
            printf("\n\rT: %f",ave );
            
            
           
            max.deselect();
            max_2.select_2();
             
        //平均化処理  
            sum_2 = 0;
            ave_2 = 0;
            j = 0;
           for( j = 0; j < r; j++)            
           {
              float temp_2 = max_2.read_temp_2();
              sum_2 += temp_2;
           }   
            
            ave_2 = sum_2 / r;
            printf("\n\rT: %f",ave_2 );
            
          
             //conversion to degrees C - from sensor output voltage per LM61 data sheet
            tempC = ((LM61*3.3)-0.600)*100.0;
           
            printf("\nC: %5.2F \n\n\n\r", tempC);
              
            FILE *fp = fopen("/sd/mydir/test_heating.csv", "a");
            if(fp == NULL) 
               { error("Could not open file for write\n");
               }
        
           fprintf(fp, "t=,%f,,,T_1,%f,,,T_2,%f,,tempC,%f\n",(double)start_h/CLOCKS_PER_SEC, ave, ave_2, tempC);
           fclose(fp); 
           wait(w_h);
        }//while_h
    
     }//if_h
     
     
     if( swi_1 == 0 && swi_2 == 1 ) //スイッチをマイコンの逆側に倒したとき
      {   
         printf("\n\n\ncolling start\n\n\n");
         
         led();
         
        while (1)
         {
            start_c = clock();
            printf("%f\n", (double)start_c/CLOCKS_PER_SEC);
   //        double sum_time = start_h/CLOCKS_PER_SEC + start_c/CLOCKS_PER_SEC;
   //         printf("%f\n", sum_time);
          
           
            max.select();                       
            max_2.deselect_2();
 
          //平均化処理      
          
            sum = 0;
            ave = 0;
            i = 0;
           for( i = 0; i < r; i++)            
             {
              float temp = max.read_temp();
              sum += temp;
             }   
            
            ave = sum / r;
            printf("\n\rT: %f",ave );
            
            
           
            max.deselect();
            max_2.select_2();
             
        //平均化処理  
            sum_2 = 0;
            ave_2 = 0;
            j = 0;
           for( j = 0; j < r; j++)            
           {
              float temp_2 = max_2.read_temp_2();
              sum_2 += temp_2;
           }   
            
            ave_2 = sum_2 / r;
            printf("\n\rT: %f",ave_2 );
            
          
             //conversion to degrees C - from sensor output voltage per LM61 data sheet
            tempC = ((LM61*3.3)-0.600)*100.0;
           
            printf("\nC: %5.2F \n\n\n\r", tempC);
              
            FILE *fp = fopen("/sd/mydir/test_cooling.csv", "a");
            if(fp == NULL) 
               { error("Could not open file for write\n");
               }
        
           fprintf(fp, "t=,%f,,,T_1,%f,,,T_2,%f,,tempC,%f\n",(double)start_c/CLOCKS_PER_SEC, ave, ave_2, tempC);
           fclose(fp); 
           wait(w_c);
        }//while_c
    
     }//if_c
     
     
      if( swi_1 == 1 && swi_2 == 1 )  // スイッチを倒さない時（真ん中の時）
         { 
           led();
           printf("\n\n\nsotp\n\n\n");
         }
         
} //main()
