////////////////////////////////////////////////// 
// Include Files
#include "mbed.h"

////////////////////////////////////////////////// 
//Pin Defines  for LED
DigitalOut sysled(LED1); //System Indicator
//DigitalOut ind1(LED2);    //
DigitalOut ind2(LED3);   //idle state indicator
DigitalOut ind3(LED4);   //adc convertion indicator




// ADC pins
AnalogIn Sense1(p15); //Sensor 1
AnalogIn Sense2(p16); //Sensor 2
AnalogIn Sense3(p17); //Sensor 3
AnalogIn Sense4(p18); //Sensor 4
AnalogIn Sense5(p19); //Sensor 5
AnalogIn Sense6(p20); //Sensor 6


//PWM signals
PwmOut x(p21);
PwmOut y(p22);
PwmOut x1(p23);
PwmOut y1(p24);
PwmOut x2(p25);
PwmOut y2(p26);


//Configure the PC Serial Port for CDC USB
Serial pc(USBTX, USBRX); // tx, rx of USB


////////////////////////////////////////////////// 

LocalFileSystem fs("fs");            //file systems

Timer timer;                           //timer


// main Program
int main() {

    unsigned short usCurrentValue;
    unsigned int i=0,j=0;
   // float beg,end;
    
                                                                    //Configure the Fastest Baud Rate
    pc.baud(115200);                                                // baud rate 
    printf("ADC TEST !!\n");                                         //print the value in the serial port
    
    
    
                                                                    //duty cycle for pwm sigmnals
    x =0.2;
    y =0.3;
    x1=0.4;
    x2=0.5;
    y1=0.6;
    y2=0.8;


                                                                      //Say the System is Ready to Run
    sysled = 1;    
     
        
 
      char fname[20];                                                   // charecter buffer
      
      //////////////////                                               // loop counts the no: of existing files
         
        while(1)
        {
         snprintf(fname, sizeof(fname), "/fs/adc%d.txt", i);            //define the fine name with fanme buffer size
          FILE *fp = fopen(fname, "r");                                 //open the file with read mode                              
                
          if(fp==NULL)                                                  // if file name is not there exit the loop
          break;
                    
            i++;
           fclose(fp);                                                  // close the opened file
        }

         FILE *fp = fopen(fname, "w");                                  //open the file in write mode
          fprintf(fp,"AD_15\t     AD_16\t     AD_17\t     AD_18\t     AD_19\t     AD_20\n");  
          
       
 
        //  timer.start();                                                //start the timer
        // beg=timer.read_ms();                                          //note the starting time of the timer
          
       
       for(j=0;j<2000;j++){                                             //loop repeats for 5 sec
        ind3 = !ind3;
        usCurrentValue = (Sense1.read_u16()&0xFFF);                     //read the adc value                                                                                                
        fprintf(fp,"%fV\t",(usCurrentValue*3.3/4095));     // print the value in the opened file
       // printf("\n ADC Val at pin15 : %f Volts = %d (Decimal Reading)",(usCurrentValue*3.3/4095),usCurrentValue);  //print the value in usb terminal
                                               
  
        
        
       ind3 = !ind3;
        usCurrentValue = (Sense2.read_u16()&0xFFF);                     //read the adc value 
       fprintf(fp,"%fV\t",(usCurrentValue*3.3/4095));
       // printf("\n ADC Val at pin16 : %f Volts = %d (Decimal Reading)",(usCurrentValue*3.3/4095),usCurrentValue);

 
        
         ind3 = !ind3;
         usCurrentValue = (Sense3.read_u16()&0xFFF);                     //read the adc value
        fprintf(fp,"%fV\t",(usCurrentValue*3.3/4095));
        // printf("\n ADC Val  at pin17 : %f Volts = %d (Decimal Reading)",(usCurrentValue*3.3/4095),usCurrentValue);


         ind3 = !ind3;
         usCurrentValue = (Sense4.read_u16()&0xFFF);                                //read the adc value
        fprintf(fp,"%fV\t",(usCurrentValue*3.3/4095));
       // printf("\n ADC Val  at pin18 : %f Volts = %d (Decimal Reading)",(usCurrentValue*3.3/4095),usCurrentValue);

        
        
        
        
         ind3 = !ind3;
         usCurrentValue = (Sense5.read_u16()&0xFFF);                         //read the adc value
        fprintf(fp," %fV\t",(usCurrentValue*3.3/4095));
      // printf("\n ADC Val  at pin19 : %f Volts = %d (Decimal Reading)",(usCurrentValue*3.3/4095),usCurrentValue);

  
        
         ind3 = !ind3;
         usCurrentValue = (Sense6.read_u16()&0xFFF);                         //read the adc value
        fprintf(fp,"%fV\t",(usCurrentValue*3.3/4095));
        //printf("\n ADC Val  at pin20 : %f Volts = %d (Decimal Reading)",(usCurrentValue*3.3/4095),usCurrentValue);
            
    fprintf(fp,"\n"); 
      //fprintf(fp,"\n");  
                                                              //seperate the one set of valus from other
    //fprintf(fp,"\n");
    }
       // end=timer.read_ms();                                                      //note the ending time of the timer
        // timer.stop();                                                         //stop the timer
       // printf("timer starts at %fms and end at %fms\n",beg,end);             //print the timer starting and ending time values
        
         fclose(fp);                // close the file  
         ind2=1;                     //indicating idle state 
                                                           
          while(1);                  // wait untill the reset

    
    
}
