/**
 * Test program.
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include "mbed.h"
#include "CameraC328.h"

DigitalIn pir(p6);
DigitalOut led(LED1);

//InterruptIn PIR(p6);

LocalFileSystem fs ("fs");

CameraC328 camera(p9, p10, CameraC328::Baud115200);
const int IMG_X = 80;
const int IMG_Y = 60;
char buf[IMG_X * IMG_Y * 2];
FILE *fp_jpeg;

void uncompressed_callback(size_t done, size_t total, char c) {
    buf[done - 1] = c;
}

void jpeg_callback(char *buf, size_t siz) {
    for (int i = 0; i < (int)siz; i++) {
        fprintf(fp_jpeg, "%c", buf[i]);
    }
}
void sync(void) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    err = camera.sync();
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::sync\n");
    } else {
        printf("[FAIL] : CameraC328::sync (Error=%02X)\n", (int)err);

    }
}

void test_uncompressed_snapshot_picture(void) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    err = camera.init(CameraC328::Color16bit, CameraC328::RawResolution80x60, CameraC328::JpegResolution160x128);
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::init\n");
    } else {
        printf("[FAIL] : CameraC328::init (Error=%02X)\n", (int)err);
    }

    for (int i = 0; i < 1; i++) {
        err = camera.getUncompressedSnapshotPicture(uncompressed_callback);
        if (CameraC328::NoError == err) {
            printf("[ OK ] : CameraC328::getUncompressedSnapshotPicture\n");
        } else {
            printf("[FAIL] : CameraC328::getUncompressedSnapshotPicture (Error=%02X)\n", (int)err);
        }

        char fname[64];
        snprintf(fname, sizeof(fname), "/fs/ucss%04d.ppm", i);
        FILE *fp = fopen(fname, "w");
        fprintf(fp, "P3\n");
        fprintf(fp, "%d %d\n", IMG_X, IMG_Y);
        fprintf(fp, "%d\n", 255);
        for (int y = 0; y < IMG_Y; y++) {
            for (int x = 0; x < IMG_X; x++) {
                int adrofs = y * (IMG_X * 2) + (x * 2);
                uint16_t dat = (buf[adrofs + 0] << 8) | (buf[adrofs + 1] << 0);
                uint8_t r = ((dat >> 11) & 0x1f) << 3;
                uint8_t g = ((dat >> 5) & 0x3f) << 2;
                uint8_t b = ((dat >> 0) & 0x1f) << 3;
                fprintf(fp,"%d %d %d\n", r, g, b);
            }
        }
        fclose(fp);
    }
}

void test_uncompressed_preview_picture(void) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    err = camera.init(CameraC328::Color16bit, CameraC328::RawResolution80x60, CameraC328::JpegResolution160x128);
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::init\n");
    } else {
        printf("[FAIL] : CameraC328::init (Error=%02X)\n", (int)err);
    }

    for (int i = 0; i < 1; i++) {
        err = camera.getUncompressedPreviewPicture(uncompressed_callback);
        if (CameraC328::NoError == err) {
            printf("[ OK ] : CameraC328::getUncompressedPreviewPicture\n");
        } else {
            printf("[FAIL] : CameraC328::getUncompressedPreviewPicture (Error=%02X)\n", (int)err);
        }

        char fname[64];
        snprintf(fname, sizeof(fname), "/fs/ucpv%04d.ppm", i);
        FILE *fp = fopen(fname, "w");
        fprintf(fp, "P3\n");
        fprintf(fp, "%d %d\n", IMG_X, IMG_Y);
        fprintf(fp, "%d\n", 255);
        for (int y = 0; y < IMG_Y; y++) {
            for (int x = 0; x < IMG_X; x++) {
                int adrofs = y * (IMG_X * 2) + (x * 2);
                uint16_t dat = (buf[adrofs + 0] << 8) | (buf[adrofs + 1] << 0);
                uint8_t r = ((dat >> 11) & 0x1f) << 3;
                uint8_t g = ((dat >> 5) & 0x3f) << 2;
                uint8_t b = ((dat >> 0) & 0x1f) << 3;
                fprintf(fp,"%d %d %d\n", r, g, b);
            }
        }
        fclose(fp);
    }
}

void test_jpeg_snapshot_picture(void) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution160x120, CameraC328::JpegResolution640x480);
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::init\n");
    } else {
        printf("[FAIL] : CameraC328::init (Error=%02X)\n", (int)err);
    }

    for (int i = 0; i < 1; i++) {
        char fname[64];
        snprintf(fname, sizeof(fname), "/fs/jpss%04d.jpg", i);
        fp_jpeg = fopen(fname, "w");

        err = camera.getJpegSnapshotPicture(jpeg_callback);
        if (CameraC328::NoError == err) {
            printf("[ OK ] : CameraC328::getJpegSnapshotPicture\n");
        } else {
            printf("[FAIL] : CameraC328::getJpegSnapshotPicture (Error=%02X)\n", (int)err);
        }

        fclose(fp_jpeg);
    }
}

void test_jpeg_preview_picture(void) {
   // sync();
   CameraC328::ErrorNumber err = CameraC328::NoError;

    err =     camera.init(CameraC328::Jpeg, CameraC328::RawResolution160x120, CameraC328::JpegResolution640x480);
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::init\n");
    } else {
        printf("[FAIL] : CameraC328::init (Error=%02X)\n", (int)err);
    }

    for (int i = 0; i < 1; i++) {
        char fname[64];
        snprintf(fname, sizeof(fname), "/fs/jppv%04d.jpg", i);
        fp_jpeg = fopen(fname, "w");
        
        
        err = camera.getJpegPreviewPicture(jpeg_callback);
        if (CameraC328::NoError == err) {
            printf("[ OK ] : CameraC328::getJpegPreviewPicture\n");
        } else {
            printf("[FAIL] : CameraC328::getJpegPreviewPicture (Error=%02X)\n", (int)err);
        }

       
      
        
         fclose(fp_jpeg);
         
          FILE *fp = fopen("/fs/pic.htm", "w");  // Open local filename
        fprintf(fp, "<title> cam test page </title>\n");
         fprintf(fp, "<body> cam test page ");
         fprintf(fp,"<div id='my_area' align='center'>");
        fprintf(fp, "<IMG SRC='JPPV0000.jpg'>"); 
       fprintf(fp, " </body>\n");
        fprintf(fp, "</a>");
        fclose(fp);

    }
}

/*void INTR_handler() {
   sync();
   
  test_jpeg_preview_picture(); 
}*/

int main() {

    printf("CameraC328\n");

    
       //PIR.rise(&INTR_handler);

    sync();
    
  while(1){
   //printf("CameraC328\n\r");
  // sync();
   
 // test_jpeg_preview_picture();
 // test_uncompressed_preview_picture();
 // test_uncompressed_snapshot_picture();
    //test_jpeg_snapshot_picture();
  if(pir==1){
    printf("somebody detected\n");
   
    sync();
    test_jpeg_preview_picture();
   
    
     
  
     }
     led=!led;
     wait(0.5);

    }
   

    return 0;
}
