#ifndef __RRANDHBRIDGE_H__
#define __RRANDHBridge_H__

#include "mbed.h"

#define RioRandHBridge_PWM_PERIOD_DEFAULT      (0.00002)   // 50KHz
#define RioRandHBridge_PWM_PULSEWIDTH_DEFAULT  (0.50)      // 50% duty cycle
 
class RioRandHBridge
{
public:
    RioRandHBridge( PinName pinPwm1, PinName pinDir1,
               PinName pinPwm2, PinName pinDir2
               );
    void setpwm1(float fPeriod, float fPulsewidth);
    void setpwm1period(float fPeriod);
    void setpwm1pulsewidth(float fPulsewidth);
    void setpwm2(float fPeriod, float fPulsewidth);
    void setpwm2period(float fPeriod);
    void setpwm2pulsewidth(float fPulsewidth);
    void motor1_stop(void);
    void motor1_ccw(void);
    void motor1_cw(void);
    void motor2_stop(void);
    void motor2_ccw(void);
    void motor2_cw(void);
    
public:
    PwmOut pwm1;
    DigitalOut Dir1;
    PwmOut pwm2;
    DigitalOut Dir2;
};

#endif /* __RRANDHBRIDGE_H__ */