/* File: RioRandHBridge.h
 * Author: Mitchell Pang      Copyright (c) 2013
 *
 * Desc: driver for RioRandHBridge Motor Driver.  For further details see
 *       header file, RioRandHBridge.h
 */

#include "mbed.h"
#include "RioRandHBridge.h"

#define SIGNAL_HIGH     (1)
#define SIGNAL_LOW      (0)

RioRandHBridge::RioRandHBridge( PinName pinPwm1, PinName pinDir1,
                      PinName pinPwm2, PinName pinDir2
                      ) :
pwm1(pinPwm1),
Dir1(pinDir1),
pwm2(pinPwm2),
Dir2(pinDir2)
{
    Dir1 = SIGNAL_LOW;
    Dir2 = SIGNAL_LOW;
    pwm1.period(RioRandHBridge_PWM_PERIOD_DEFAULT);
    pwm1 = RioRandHBridge_PWM_PULSEWIDTH_DEFAULT;
    pwm2.period(RioRandHBridge_PWM_PERIOD_DEFAULT);
    pwm2 = RioRandHBridge_PWM_PULSEWIDTH_DEFAULT;
}

void RioRandHBridge::setpwm1(float fPeriod, float fPulsewidth)
{
    pwm1.period(fPeriod);
    pwm1 = fPulsewidth;
}

void RioRandHBridge::setpwm1period(float fPeriod)
{
    pwm1.period(fPeriod);
}

void RioRandHBridge::setpwm1pulsewidth(float fPulsewidth)
{
    pwm1 = fPulsewidth;
}

void RioRandHBridge::setpwm2(float fPeriod, float fPulsewidth)
{
    pwm2.period(fPeriod);
    pwm2 = fPulsewidth;
}

void RioRandHBridge::setpwm2period(float fPeriod)
{
    pwm2.period(fPeriod);
}

void RioRandHBridge::setpwm2pulsewidth(float fPulsewidth)
{
    pwm2 = fPulsewidth;
}


void RioRandHBridge::motor1_stop(void)
{
    pwm1 = 0.0;
}

void RioRandHBridge::motor1_ccw(void)
{
    Dir1 = SIGNAL_LOW;
}

void RioRandHBridge::motor1_cw(void)
{
    Dir1 = SIGNAL_HIGH;
}

void RioRandHBridge::motor2_stop(void)
{
    pwm2 = 0.0;
}

void RioRandHBridge::motor2_ccw(void)
{
    Dir2 = SIGNAL_LOW;
}

void RioRandHBridge::motor2_cw(void)
{
    Dir2 = SIGNAL_HIGH;
}


