#include "mbed.h"
#include "Regrind.h"

Regrind::Regrind (){
    timeSeen = 0;
    location = 0;
    velocity = 0;
    acceleration = 0;
    divert = 0;
    pastDiverter = 0;
    
    t = Timer();
};

Regrind::Regrind (double tS, int l, double v, double a, int d, int pD){
    timeSeen = tS;
    location = l;
    velocity = v;
    acceleration = a;
    divert = d;
    pastDiverter = pD;
    
    t.start();
};

void Regrind::setVelocity(double distance){
    int timePassed_us = t.read_us();
    velocity = 2*distance/timePassed_us/1e6;
    location = 2;
};

void Regrind::setAcceleration(double distance){
    t.stop();
    int timePassed_us = t.read_us();
    acceleration = (2*distance)/((timePassed_us/1e6)*(timePassed_us/1e6));
    location = 3;
};

void Regrind::clearRegrind(){
    timeSeen = 0;
    location = 0;
    velocity = 0;
    acceleration = 0;
    divert = 0;
    pastDiverter = 0;
    t.reset();
};