#include "mbed.h"
#include "ID12RFID.h"
#include "Keypad.h"
#include "uLCD_4DGL.h"

ID12RFID rfid(p14); // uart rx
Serial pc(USBTX, USBRX);
Keypad   keypad(p29,p24,p25,p27,p28,p30,p26);
uLCD_4DGL lcd(p9, p10, p11);

const int key[]= {5453460, 5469457, 1234567, 2345678};
const int cost[]= {3,4, 5, 6};
const char* item[]= {"milk","bread", "eggs", "juice"};

int getIndex(int id);
void clearId();
char keypadId[7];

int main()
{
    printf("Hello World\n");

    int num;
    int indexl=0;
    int Id =4;
    int indexKeyPad ;
    int yValue = 2;
    int totalCost =0;
    lcd.baudrate(3000000);
    lcd.background_color(0);
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("Welcome!");
    lcd.locate(0, 15);
    lcd.printf("Total:");

    int j = 0;
    while(1) {
        if(rfid.readable()) {
            num = rfid.read();
            indexl = getIndex(num);

            pc.printf("id: %d, cost: %d, item: %s \n", key[indexl], cost[indexl], item[indexl]);
            pc.printf("RFID Tag number : %d, %d\n", num, indexl);

            lcd.locate(0, yValue);
            lcd.printf("%s", item[indexl]);
            lcd.locate(15, yValue);
            lcd.printf("$%d", cost[indexl]);
            totalCost = totalCost + cost[indexl];
            lcd.locate(15, 15);
            lcd.printf("$%d", totalCost);
            yValue = yValue + 2;
        }
        
        if(keypad.isNewAndPressed()) {
            if(keypad.getKey() == '#') {
                j=0;
                lcd.color(BLACK);
                lcd.locate(0,yValue);
                lcd.printf("%s", keypadId);
                lcd.color(GREEN);
                Id = atoi (keypadId);
                indexKeyPad = getIndex(Id);
                pc.printf("%d, %d\n", Id, indexKeyPad);
                lcd.locate(0, yValue);
                lcd.printf("%s", item[indexKeyPad]);
                lcd.locate(15, yValue);
                lcd.printf("$%d", cost[indexKeyPad]);
                totalCost = totalCost + cost[indexKeyPad];
                lcd.locate(15, 15);
                lcd.printf("$%d", totalCost);
                yValue = yValue + 2;
                clearId();

            } else {
                keypadId[j] = keypad.getKey();
                lcd.locate(0, yValue);
                lcd.printf("%s\n", keypadId);
                j++;
            }

        }
    }
}
int getIndex(int id)
{
    int i, indexl =0;
    for(i=0; i<4; i++) {
        if(key[i] == id) {
            indexl = i;
        }
    }
    return indexl;
}

void clearId(){
    int k;
    for(k=0; k<7; k++){
        keypadId[k] = ' ';
        }
    }