#ifndef MBED_SPFUN_KEYPAD_H
#define MBED_SPFUN_KEYPAD_H

#include "mbed.h"

class Keypad
{
private: // private member functions
    int getColHit();
    int getRowHit();
    char decode();
    void tristate_all();
    int log2(int num);
public:

    /** Create an ID12 RFID interface, connected to the specified Serial rx port
    *
    * @param rx Recieve pin
    */
    Keypad(PinName row1, PinName row2, PinName row3, PinName row4, PinName col1, PinName col2, PinName col3);

    int getKey();
    int isNewAndPressed();

private:
    BusInOut rows;
    BusInOut cols;
    char last_key_hit;
    int row_hit;
    int col_hit;

};
#endif