#include "mbed.h"
#include <math.h>
#include<stdlib.h> 

extern "C" int add(int a, int b); 
extern "C" int sub(int a, int b); 
extern "C" int mul(int a, int b); 
extern "C" int udiv(int a, int b); 

const int m_r = 4;
const int n_c = 3;

DigitalOut R[4] = {PD_0, PB_7, PB_6, PA_3};
DigitalIn C[3] = {PA_2, PA_1, PA_5};
DigitalOut led(LED1);

char NumberPad[m_r][n_c]= {
    {'1', '2', '3'},
    {'4', '5', '6'},
    {'7', '8', '9'},
    {'*', '0', '#'}
    };

int count=0;
int number =0;


int exitt = 0;
char read[1]={0};
char input[256]={0};

int NumberPad1()
{
while(1)
{ 

    for( int i=0; i < m_r; i++){
    R[0]=1;
    R[1]=1; 
    R[2]=1; 
    R[3]=1;
    R[i]=0; 
    wait(0.010);
    for( int j=0; j < n_c; i++){
    if(C[j]==0){
        wait (.500);
    read[0] = NumberPad[i][j]; 
    if (read[0]== NumberPad[3][0]){ 
    break; 
    }
    if (read[0]== NumberPad[3][2]){ 
    exitt = 1; 
    break; 
    }
    input[count]= NumberPad[i][j];
    count++; 
    wait(0.005);
    } 
    } 
    if(exitt==1){ 
    break; 
    } 
    } 
    if(exitt==1){ 
    break; 
    } 
    } 
    number = int(input);
    return number;
    }


int main(){
int Menu, n1, n2;
while(1){
printf("No. 1 followed by #: \n"); 
n1 = NumberPad1(); 
wait(.100); 
printf("%d\n\r", n1); 
printf("No. 2 followed by #: \n\r"); 
n2 = NumberPad1(); 
wait(.100);
printf("%d\n\r", n2);
printf("Operation followed by #:\n\r1: add\n\r2: sub\n\r3: mul\n\r4: div\n\r"); 
Menu = NumberPad1();
wait(.100);
switch(Menu){
case 1: printf("Result = %d \n\r", add(n1, n2)); 
break; 
case 2: printf("Result = %d \n\r", sub(n1, n2)); 
break; 
case 3: printf("Result = %d \n\r", mul(n1, n2)); 
break; 
case 4: printf("Result = %d \n\r", udiv(n1, n2)); 
break; 
} 
} 
} 