#include "mbed.h"
#include "BLEDevice.h"
#include "BLEMIDI.h"
#include "math.h"
 
BLEDevice device;
BLEMIDI bleMidi(&device);
 
PwmOut sound(P0_6);
 
Ticker midinote;  
 
void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason) {
    bleMidi.onBleDisconnection(handle, reason);
}
 
void connectionCallback(Gap::Handle_t handle, Gap::addr_type_t type, const Gap::address_t addr, const Gap::ConnectionParams_t *params) {
    bleMidi.onBleConnection(handle, type, addr, params);
}
 
void onNoteOn(uint8_t channel, uint8_t note, uint8_t velocity) {
    sound.write(0.5f);
    sound.period(1.0f / (440.0f * (float)pow(2.0, (note - 69.0) / 12.0)));
}
 
void onNoteOff(uint8_t channel, uint8_t note, uint8_t velocity) {
    sound.pulsewidth(0);
}

void note(){
    bleMidi.sendNoteOn(0, 63, 127);
 }
 
int main(void) {
    device.onConnection(connectionCallback);
    device.onDisconnection(disconnectionCallback);
    
    bleMidi.attachNoteOn(onNoteOn);
    bleMidi.attachNoteOff(onNoteOff);
    midinote.attach(&note, 2.0); // the address of the function to be attached (flip) and the interval (2 seconds) 
      
    for (;;) {
        device.waitForEvent();
        
    }
}
