#include "mbed.h"

Timeout timer;

typedef enum{
 DO,
 RE,
 MI,
 FA,
 SOL,
 LA,
 SI,
 DO1,
 }Nota;
 
 Nota selected_nota = DO1;

DigitalOut pwm_green(D8); // IO used by pwm_io function
DigitalOut pwm_red(D7);
DigitalOut pwm_blue(D2);

int on_delay = 0;
int off_delay = 0;

void toggleOff_green();
void toggleOff_blue();
void toggleOff_red();

void toggleOn_green() {
    pwm_green = 1;
    timer.attach_us(toggleOff_green, on_delay);
}

void toggleOn_red() {
    pwm_red = 1;
    timer.attach_us(toggleOff_red, on_delay);
}

void toggleOn_blue() {
    pwm_blue = 1;
    timer.attach_us(toggleOff_blue, on_delay);
}

void toggleOff_green() {
    pwm_green = 0;
    timer.attach_us(toggleOn_green, off_delay);
}

void toggleOff_red() {
    pwm_red = 0;
    timer.attach_us(toggleOn_red, off_delay);
}

void toggleOff_blue() {
    pwm_blue = 0;
    timer.attach_us(toggleOn_blue, off_delay);
}

// p_us = signal period in micro_seconds
// dc   = signal duty-cycle (0.0 to 1.0)
void pwm_io_green(int p_us, float dc) {
    timer.detach();
    if ((p_us == 0) || (dc == 0)) {
        pwm_green = 0;
        return;
    }
    if (dc >= 1) {
        pwm_green = 1;
        return;
    }
    on_delay = (int)(p_us * dc);
    off_delay = p_us - on_delay;
    toggleOn_green();
}

void pwm_io_red(int p_us, float dc) {
    timer.detach();
    if ((p_us == 0) || (dc == 0)) {
        pwm_red = 0;
        return;
    }
    if (dc >= 1) {
        pwm_red = 1;
        return;
    }
    on_delay = (int)(p_us * dc);
    off_delay = p_us - on_delay;
    toggleOn_red();
}

void pwm_io_blue(int p_us, float dc) {
    timer.detach();
    if ((p_us == 0) || (dc == 0)) {
        pwm_blue = 0;
        return;
    }
    if (dc >= 1) {
        pwm_blue = 1;
        return;
    }
    on_delay = (int)(p_us * dc);
    off_delay = p_us - on_delay;
    toggleOn_blue();
}

int main() {
    
    pwm_io_green(20, 0.50); // 20ms - 25%
    pwm_io_blue(20, 0.50);
    pwm_io_red(20, 0.50);
    
    while(1) {
        switch (selected_nota){
            case DO:    pwm_io_red(20, 1.00);
                        pwm_io_green(20, 0.00); // 20ms - 25%
                        pwm_io_blue(20, 0.00);
                        
                break;
            case RE:    pwm_io_red(20, 1.00);
                        pwm_io_green(20, 0.60); // 20ms - 25%
                        pwm_io_blue(20, 0.00);
                break;
            case MI:    pwm_io_red(20, 1.00);
                        pwm_io_green(20, 1.00); // 20ms - 25%
                        pwm_io_blue(20, 0.00);
                break;
            case FA:    pwm_io_red(20, 0.00);
                        pwm_io_green(20, 1.00); // 20ms - 25%
                        pwm_io_blue(20, 0.00);
                break;
            case SOL:   pwm_io_red(20, 0.00);
                        pwm_io_green(20, 0.00); // 20ms - 25%
                        pwm_io_blue(20, 1.00);
                break;
            case LA:    pwm_io_red(20, 0.20);
                        pwm_io_green(20, 0.00); // 20ms - 25%
                        pwm_io_blue(20, 0.60);
                break;
            case SI:    pwm_io_red(20, 1.00);
                        pwm_io_green(20, 0.00); // 20ms - 25%
                        pwm_io_blue(20, 1.00);
                break;
            case DO1:   pwm_io_red(20, 1.00);
                        pwm_io_green(20, 1.00); // 20ms - 25%
                        pwm_io_blue(20, 1.00);
                break;

        }
    }
}
 