#include "mbed.h"
#include "SakuraIO.h"

DigitalOut status_led(PB_5);

DigitalOut patlite_r(PB_4);
DigitalOut patlite_y(PB_3);
DigitalOut patlite_g(PA_15);
DigitalOut patlite_4(PA_12);
DigitalOut patlite_5(PA_11);
DigitalOut patlite_6(PA_8);
DigitalOut patlite_7(PB_1);
DigitalOut patlite_8(PB_0);

DigitalOut patlite_map[8] = {
    patlite_r, patlite_y, patlite_g, patlite_4,
    patlite_5, patlite_6, patlite_7, patlite_8
};

//SPI spi(D11, D12, D13); // mosi, miso, sclk
//DigitalOut cs(D10);
I2C i2c(PB_7, PB_6);        // sda, scl
uint64_t counter = 0;


int main()
{
    //SakuraIO_SPI sakuraio( spi, cs );
    SakuraIO_I2C sakuraio(i2c);

    // Waiting to come online
    for(;;) {
        if( (sakuraio.getConnectionStatus() & 0x80) == 0x80 ) break;
        for (int i = 0; i < 6; i++) {
            patlite_y = !(i % 2);
            wait_ms(100);
        }
        wait_ms(1000);
    }

    patlite_y = 1;
    wait(1);
    patlite_y = 0;


    while(1) {
        uint8_t avail;
        uint8_t queued;

        for(uint8_t i=0; i<queued; i++) {
            uint8_t channel;
            uint8_t type;
            uint8_t values[8];
            int64_t offset;
            int32_t value;

            // RXキューから点灯要求を取り出す
            uint8_t ret = sakuraio.dequeueRx(&channel, &type, values, &offset);
            value = *((int32_t *)values);
            if(ret == 0x01) {
                // 取り出せたらチャンネルIDを元に動作振り分け
                // https://gist.github.com/misodengaku/17b8194dcd0c3038ea5ce7f60ef04072
                if (channel < 7) {
                    // tentou
                    if (value == 1) {
                        patlite_map[channel] = 1;
                        sakuraio.enqueueTx((uint8_t)channel, (int32_t)1);
                    } else {
                        patlite_map[channel] = 0;
                        sakuraio.enqueueTx((uint8_t)channel, (int32_t)0);
                    }
                }

            }
        }
        counter++;
        if (counter % 100 == 0) {
            sakuraio.enqueueTx(24, counter);
            status_led = !status_led;
        }
        sakuraio.getTxQueueLength(&avail, &queued);
        if(queued >= 30) {
            sakuraio.clearTx();
        } else if(queued >= 5) {
            sakuraio.send();
        }

        wait_ms(10);
    }

}

