#ifndef _SEMAPHORE_H_
#define _SEMAPHORE_H_

/*
 * http://mbed.org/forum/mbed/topic/181/#comment-799
 */

class Semaphore {
public:
    Semaphore(): s(SemFree) {}

    bool take(bool block = true) {
        int oldval;
        do {
            oldval = __ldrex(&s);
        } while ((block && oldval == SemTaken) || __strex(SemTaken, &s) != 0);
        if (!block) {
            __clrex();
        }
        return (oldval == SemFree);
    }

    void release() {
        s = SemFree;
    }

private:
    enum { SemFree, SemTaken };
    int s;
};

#endif