//Based on http://mbed.org/users/jf1vrr/programs/RTC8564NB_Clock/lqbcpu

#include "mbed.h"
#include "RTC8564.h"

Serial pc(USBTX, USBRX);

char year, month, day, week;
char hour, minute, sec;

char week_chr[7][4] = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};


int main() {
    //2012.06.20 00:30:00 Wed
    rtc_setdaytime("12", "06", "20", "00", "30", "00", "3");
    
    while(1) { 
        year = rtc_read(YEARS);
        month = rtc_read(MONTHS);
        day = rtc_read(DAYS);
        week = rtc_read(WEEKDAYS);
        hour = rtc_read(HOURS);
        minute = rtc_read(MINUTES);
        sec = rtc_read(SECONDS);
        pc.printf("20%c%c/%c%c/%c%c %s\n",
            ((year >> 4) & 0x03) + 0x30, (year & 0x0F) + 0x30, 
                ((month >> 4) & 0x01) + 0x30, (month & 0x0F) + 0x30, 
                    ((day >> 4) & 0x03)+ 0x30, (day & 0x0F) + 0x30, 
                        week_chr[week & 0x07]);
        pc.printf("%c%c:%c%c:%c%c\n",
            ((hour >> 4) & 0x03) + 0x30, (hour & 0x0F) + 0x30, 
                (minute >> 4) + 0x30, (minute & 0x0F) + 0x30, 
                    (sec >> 4) + 0x30, (sec & 0x0F) + 0x30 );
        
        wait(0.1);
    }
}
