#include "mbed.h"
#include "RTC8564.h"

I2C i2c(p9, p10);

void rtc_write(char address, char value)
{
    i2c.start();
    i2c.write(RTC8564NB_ADR);
    i2c.write(address);
    i2c.write(value);
    i2c.stop();
}

char rtc_read(char address)
{
    char value;
    i2c.start();
    i2c.write(RTC8564NB_ADR);
    i2c.write(address);
    i2c.start();
    i2c.write(RTC8564NB_ADR | _READ);
    value = i2c.read(0);
    i2c.stop();
    
    return value;
}

void time_just()
{
    char _min, _hour;
    _min = rtc_read(MINUTES);
    if (_min >= 0x30) { 
            _hour = rtc_read(HOURS);
            if (_hour == 0x23)
                _hour = 0x00;
            else if ((_hour & 0x0F) == 0x09)
                _hour = (_hour & 0xF0) + 0x10;
            else
                _hour = _hour + 0x01;
            rtc_write(HOURS, _hour);
    }
    rtc_write(MINUTES, 0x00);
    rtc_write(SECONDS, 0x00);
}


void rtc_setdaytime(char y[3], char m[3], char d[3], char h[3], char min[3], char s[3], char week_val[2])
{
    rtc_write(CONTROL1, 0x20); //stop
    rtc_write(CONTROL2, 0x00);
    rtc_write(YEARS, ((y[0]-0x30)<<4)+(y[1]-0x30)); 
    rtc_write(MONTHS, ((m[0]-0x30)<<4)+(m[1]-0x30));
    rtc_write(DAYS, ((d[0]-0x30)<<4)+(d[1]-0x30));
    rtc_write(HOURS, ((h[0]-0x30)<<4)+(h[1]-0x30));
    rtc_write(MINUTES, ((min[0]-0x30)<<4)+(min[1]-0x30));
    rtc_write(SECONDS, ((s[0]-0x30)<<4)+(s[1]-0x30));
    rtc_write(WEEKDAYS, week_val[0] - 0x30); //Sunday = "0", Monday = "1" ...
    rtc_write(CLOCKOUT_FREQ, 0x00); // 0x83 = TE on & 1Hz
    rtc_write(TIMER_CONTROL, 0x00);
    rtc_write(CONTROL1, 0x00); //start
    return;
}