#include "mbed.h"
#include "LCD_DISCO_F469NI.h"
#include "rtos.h"
#include <string>
#include "stdio.h"


#include <errno.h>
#include <functional>

#include "BlockDevice.h"


#include "LittleFileSystem.h"


LCD_DISCO_F469NI lcd;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

Thread thread, led_thread, queue_thread, button_thread;



#define BUFFER_MAX_LEN 10
#define FORCE_REFORMAT true


#define SAMPLE_FLAG1 (1UL << 0)
#define SAMPLE_FLAG2 (1UL << 9)

EventFlags event_flags;




//mikoriko test

typedef struct {
    float    voltage;   /* AD result of measured voltage */
    float    current;   /* AD result of measured current */
    uint32_t counter;   /* A counter value               */
} message_t;

MemoryPool<message_t, 16> mpool;
Queue<message_t, 16> queue;



BlockDevice *bd = BlockDevice::get_default_instance();
LittleFileSystem fs("fs");





void test_flag(void)
{
    while(true){

    
    ThisThread::sleep_for(1000);
		event_flags.set(SAMPLE_FLAG1);
    }
}


void led_th(void)
{
    while(true){

    led2=!led2;
    ThisThread::sleep_for(300);
    }
}

void q_thread(void)
{
	int i;
	i=0;
	while(true){
		i++; // fake data update
    message_t *message = mpool.alloc();
    message->voltage = (i * 0.1) * 33;
    message->current = (i * 0.1) * 11;
    message->counter = i;
    queue.put(message);
		
		ThisThread::sleep_for(700);
	}
}


void erase() {
    printf("Initializing the block device... ");
    fflush(stdout);
    int err = bd->init();
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        error("error: %s (%d)\n", strerror(-err), err);
    }

    printf("Erasing the block device... ");
    fflush(stdout);
    err = bd->erase(0, bd->size());
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        error("error: %s (%d)\n", strerror(-err), err);
    }

    printf("Deinitializing the block device... ");
    fflush(stdout);
    err = bd->deinit();
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        error("error: %s (%d)\n", strerror(-err), err);
    }
}


void mount(void)
{
    // Try to mount the filesystem
    printf("Mounting the filesystem... ");
    fflush(stdout);
    int err = fs.mount(bd);
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err || FORCE_REFORMAT) {
        // Reformat if we can't mount the filesystem
        printf("formatting... ");
        fflush(stdout);
        err = fs.reformat(bd);
        printf("%s\n", (err ? "Fail :(" : "OK"));
        if (err) {
            error("error: %s (%d)\n", strerror(-err), err);
        }
    }

    // Open the numbers file
    printf("Opening \"/fs/numbers.txt\"... ");
    fflush(stdout);
    FILE *f = fopen("/fs/numbers.txt", "r+");
    printf("%s\n", (!f ? "Fail :(" : "OK"));
    if (!f) {
        // Create the numbers file if it doesn't exist
        printf("No file found, creating a new file... ");
        fflush(stdout);
        f = fopen("/fs/numbers.txt", "w+");
        printf("%s\n", (!f ? "Fail :(" : "OK"));
        if (!f) {
            error("error: %s (%d)\n", strerror(errno), -errno);
        }

        for (int i = 0; i < 10; i++) {
            printf("\rWriting numbers (%d/%d)... ", i, 10);
            fflush(stdout);
            err = fprintf(f, "    %d\n", i);
            if (err < 0) {
                printf("Fail :(\n");
                error("error: %s (%d)\n", strerror(errno), -errno);
            }
        }
        printf("\rWriting numbers (%d/%d)... OK\n", 10, 10);

        printf("Seeking file... ");
        fflush(stdout);
        err = fseek(f, 0, SEEK_SET);
        printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
        if (err < 0) {
            error("error: %s (%d)\n", strerror(errno), -errno);
        }
    }

    // Go through and increment the numbers
    for (int i = 0; i < 10; i++) {
        printf("\rIncrementing numbers (%d/%d)... ", i, 10);
        fflush(stdout);

        // Get current stream position
        long pos = ftell(f);

        // Parse out the number and increment
        char buf[BUFFER_MAX_LEN];
        if (!fgets(buf, BUFFER_MAX_LEN, f)) {
            error("error: %s (%d)\n", strerror(errno), -errno);
        }
        char *endptr;
        int32_t number = strtol(buf, &endptr, 10);
        if (
            (errno == ERANGE) || // The number is too small/large
            (endptr == buf) ||   // No character was read
            (*endptr && *endptr != '\n') // The whole input was not converted
        ) {
            continue;
        }
        number += 1;

        // Seek to beginning of number
        fseek(f, pos, SEEK_SET);
    
        // Store number
        fprintf(f, "    %d\n", number);

        // Flush between write and read on same file
        fflush(f);
    }
    printf("\rIncrementing numbers (%d/%d)... OK\n", 10, 10);

    // Close the file which also flushes any cached writes
    printf("Closing \"/fs/numbers.txt\"... ");
    fflush(stdout);
    err = fclose(f);
    printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
    if (err < 0) {
        error("error: %s (%d)\n", strerror(errno), -errno);
    }
    
    // Display the root directory
    printf("Opening the root directory... ");
    fflush(stdout);
    DIR *d = opendir("/fs/");
    printf("%s\n", (!d ? "Fail :(" : "OK"));
    if (!d) {
        error("error: %s (%d)\n", strerror(errno), -errno);
    }

    printf("root directory:\n");
    while (true) {
        struct dirent *e = readdir(d);
        if (!e) {
            break;
        }

        printf("    %s\n", e->d_name);
    }

    printf("Closing the root directory... ");
    fflush(stdout);
    err = closedir(d);
    printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
    if (err < 0) {
        error("error: %s (%d)\n", strerror(errno), -errno);
    }

    // Display the numbers file
    printf("Opening \"/fs/numbers.txt\"... ");
    fflush(stdout);
    f = fopen("/fs/numbers.txt", "r");
    printf("%s\n", (!f ? "Fail :(" : "OK"));
    if (!f) {
        error("error: %s (%d)\n", strerror(errno), -errno);
    }

    printf("numbers:\n");
    while (!feof(f)) {
        int c = fgetc(f);
        printf("%c", c);
    }

    printf("\rClosing \"/fs/numbers.txt\"... ");
    fflush(stdout);
    err = fclose(f);
    printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
    if (err < 0) {
        error("error: %s (%d)\n", strerror(errno), -errno);
    }

    // Tidy up
    printf("Unmounting... ");
    fflush(stdout);
    err = fs.unmount();
    printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
    if (err < 0) {
        error("error: %s (%d)\n", strerror(-err), err);
    }
        
    printf("Mbed OS filesystem example done!\n");
}






DigitalIn  mypin(BUTTON1);
void button_test(void)
{
int stat=0, butinf;

mypin.mode(PullNone);

    while(1)
    {

        butinf = mypin.read();
        if(stat==0 && butinf==1){
            stat = 1;
            led3=!led3;
            printf("button presed \n\r");

            //erase();
            mount();


        }else{
            if(butinf==0){stat=0;}
        }
        
        ThisThread::sleep_for(10);
    }
// mtx.lock();
//     led3=!led3;
//     mtx.unlock();
}




int main()
{    
	
		bool st=false;
    led1 = 1; 
    led2 = 1;
	uint32_t flags_read = 0;
  
	char buffer[50];				
	int c = 0;
	
	printf("start mbed TEST START \n\r");


  
    thread.start(test_flag);
	led_thread.start(led_th);
	queue_thread.start(q_thread);
    button_thread.start(button_test);
        
	
  
    //lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"MBED EXAMPLE", CENTER_MODE);
    //ThisThread::sleep_for(1);
  
	
	
		
		lcd.Clear(LCD_COLOR_BLUE);
		lcd.SetBackColor(LCD_COLOR_BLUE);
		
	
	
    while(1)
    {
			
			flags_read = event_flags.wait_any(SAMPLE_FLAG1, 10);
			
			if(flags_read&SAMPLE_FLAG1){
				//lcd.Clear(LCD_COLOR_BLUE);

				if(st){					
					lcd.SetTextColor(LCD_COLOR_WHITE);
					lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"FLAG 0 SET EVERY 1 SEC", LEFT_MODE);
				}else{
					lcd.SetTextColor(LCD_COLOR_DARKRED);
					lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"FLAG 0 SET EVERY 1 SEC", LEFT_MODE);
                
				}
				st=!st;				
			}
			
			
			
			  osEvent evt = queue.get(10);
        if (evt.status == osEventMessage) {
            message_t *message = (message_t *)evt.value.p;
					
						c++;
						sprintf(buffer, "queue message counter: %d", c);
						lcd.SetTextColor(LCD_COLOR_ORANGE);
						lcd.DisplayStringAt(0, LINE(4), (uint8_t *)buffer, LEFT_MODE);					
					
						sprintf(buffer, "Voltage: %d", message->voltage);
						lcd.SetTextColor(LCD_COLOR_LIGHTGREEN);
						lcd.DisplayStringAt(0, LINE(5), (uint8_t *)buffer, LEFT_MODE);
						
						sprintf(buffer, "Current: %d", message->current);
						lcd.SetTextColor(LCD_COLOR_LIGHTGREEN);
						lcd.DisplayStringAt(0, LINE(6), (uint8_t *)buffer, LEFT_MODE);
					
						sprintf(buffer, "Counter: %d", message->counter);
						lcd.SetTextColor(LCD_COLOR_LIGHTGREEN);
						lcd.DisplayStringAt(0, LINE(7), (uint8_t *)buffer, LEFT_MODE);


            mpool.free(message);
        }
			
			
			
			
			/*
      lcd.Clear(LCD_COLOR_BLUE);
      lcd.SetBackColor(LCD_COLOR_BLUE);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      ThisThread::sleep_for(300);
      lcd.DisplayStringAt(0, LINE(4), (uint8_t *)"DISCOVERY", CENTER_MODE);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"STM32F469NI", CENTER_MODE);
      ThisThread::sleep_for(1000);

      lcd.Clear(LCD_COLOR_GREEN);
      
      lcd.SetTextColor(LCD_COLOR_BLUE);
      lcd.FillRect(10, 20, 50, 50);
      ThisThread::sleep_for(100);
      lcd.SetTextColor(LCD_COLOR_BROWN);
      lcd.FillCircle(80, 80, 50);
      ThisThread::sleep_for(100);
      lcd.SetTextColor(LCD_COLOR_YELLOW);
      lcd.FillEllipse(150, 150, 50, 100);
      ThisThread::sleep_for(100);
      lcd.SetTextColor(LCD_COLOR_RED);
      lcd.FillCircle(200, 200, 40);
      ThisThread::sleep_for(1000);

      lcd.SetBackColor(LCD_COLOR_ORANGE);
      lcd.SetTextColor(LCD_COLOR_CYAN);
      BSP_LCD_SetFont(&Font20);
      lcd.DisplayStringAt(0, LINE(7), (uint8_t *)"HAVE FUN !!!", CENTER_MODE);
      ThisThread::sleep_for(1000);

      led1 = !led1;
      ThisThread::sleep_for(500);
			*/
    }
}

