#include "mbed.h"
#define BUTTON1 p14

int lauflicht(bool richtung, int time, int &anz);
void nibbleLeds(int value);
void printb(uint8_t x);

BusOut myleds(LED1,LED2,LED3,LED4);
DigitalIn button(BUTTON1);

const int INIT = 0x03;

int main()
{
    int anzahl, anz;
    uint8_t value = INIT;
    anzahl = lauflicht(true, 400, anz=0);
    printf("anzahl = %d\n", anzahl);

    nibbleLeds(value);
    printb(value);
    wait(0.1);
}

int lauflicht(bool richtung, int time, int &anz)
{
    int i;
    uint8_t lauf = 0x01;

    if(!richtung)
        lauf= 0x08;
    while(1) {
        nibbleLeds(lauf&0x0F);
        if(richtung) {

            lauf = lauf << 1;
            if(lauf>8)
                lauf = 0x01;

        } else {
            lauf = lauf >>1;
            if(lauf == 0)
                lauf = 0x08;
        }
        if(button)
            break;
        wait_ms(time);
        anz++;

    }
    return anz;


}

void printb(uint8_t x)
{

    for(int i=sizeof(x)<<3; i; i--)
        putchar('0'+((x>>(i-1))&1));
    printf("\n");

}


void nibbleLeds (int value)
{

    myleds = value%16;

}