//Author: Miguel Ruiz García
//Company: University of Cantabria. 2016
//mail: mrg47@alumnos.unican.es


#define PI 3.1415952
#define WIDTH 320
#define HEIGHT 8
#define DEPTH 24
#define RAIZ2 1.414214
#define PI16 0.19635
const float coeff[8][8]={
        {1.000, 0.980658, 0.923381, 0.830384, 0.705265, 0.552863, 0.379075, 0.190623},
        {1.000000, 0.830384, 0.379075, -0.200829, -0.712605, -0.982642, -0.919336, -0.544161},
        {1.000000, 0.552863, -0.388685, -0.982642, -0.697848, 0.211013, 0.931171, 0.818607},
        {1.000000, 0.190623, -0.927326, -0.544161, 0.719867, 0.818607, -0.407777, -0.974070},
        {1.000000, -0.200829, -0.919336, 0.570086, 0.690356, -0.847373, -0.350003, 0.987954},
        {1.000000, -0.561505, -0.369424, 0.976372, -0.727052, -0.159885, 0.906605, -0.858241},
        {1.000000, -0.836138, 0.398253, 0.170150, -0.682790, 0.971663, -0.942098, 0.603785},
        {1.000000, -0.982642, 0.931171, -0.847373, 0.734158, -0.595456, 0.436082, -0.261569} };


void DCT(int matrix[8][8][3],short int f[HEIGHT][WIDTH][3],int p_fil,int p_col){
    int i=0,j=0,u,v;
    float cu=1.0,cv=1.0;
    int linea,bpp;

    Uint8 *pixel;


    for(u=p_fil;u<8+p_fil;u++){

        if(u-p_fil==0){
            cu=RAIZ2/2;
        }
        else cu=1.0;
        for(v=p_col;v<8+p_col;v++){
            f[u][v][0]=0;
            f[u][v][1]=0;
            f[u][v][2]=0;
            if(v-p_col==0){
                cv=RAIZ2/2;

            }
            else cv=1.0;

            float dato=0.0;
            float dato2=0.0;

            float acum0=0.0,acum1=0.0,acum2=0.0;

            for(i=0;i<8;i++){

                for(j=0;j<8;j++){

                    /*dato=(float)(cos((float)(((j*2)+1)*(v-p_col)*PI16)));
                    dato2=(float)(cos((float)(((i*2)+1)*(u-p_fil)*PI16)));*/
                    
                    dato=coeff[j][v-p_col];//(float)(cos((float)(((j*2)+1)*(v-p_col)*PI16)));//
                    dato2=coeff[i][u-p_fil];

                    acum0+=(float)(dato*dato2*(matrix[i][j][0]));//crominancia V
                    acum1+=(float)(dato*dato2*(matrix[i][j][1]));//crominancia U
                    acum2+=(float)(dato*dato2*(matrix[i][j][2]));//luminancia Y

                }
            }
                float dato3=(float)((cu*cv)/4);
                acum0*=(float)dato3;
                acum1*=(float)dato3;
                acum2*=(float)dato3;

                f[u][v][0]=(short int)acum0;
                f[u][v][1]=(short int)acum1;
                f[u][v][2]=(short int)acum2;


        }


    }

 
}

void rgb_to_yuv(short int f[HEIGHT][WIDTH][3]){
    

    Uint8 *pixel;
    int i=0,j=0;
    const int linea=1920,bpp=3;
    float y=0.0,u=0.0,v=0.0;
    
    for(i=0;i<HEIGHT;i++){
        for(j=0;j<WIDTH;j++){
            short int dato2=f[i][j][2];
            short int dato1=f[i][j][1];
            short int dato=f[i][j][0];
            y=dato2*0.257+dato1*0.504+dato*0.098+16;//y
        //  y=dato2*0.257+(Uint8)(*(pixel+1)>>1)+*(pixel)/100+16;//y
            u=dato2*-0.148+dato1*-0.291+dato*0.439+128;//u
            v=dato2*0.439+dato1*-0.368+dato*-0.071+128;//v
            if(y>235) y=235;
            if(u>240) u=240;
            if(v>240) v=240;

            if(y<16) y=16;
            if(u<16) u=16;
            if(v<16) v=16;
        /*  y=*(pixel+2)*0.183+(*(pixel+1))*0.614+*(pixel)*0.062+16;//y
            u=*(pixel+2)*-0.101+*(pixel+1)*-0.339+*(pixel)*0.439+128;//u
            v=*(pixel+2)*0.439+*(pixel+1)*-0.339+*(pixel)*-0.040+128;//v*/

//http://www.equasys.de/colorconversion.html

            f[i][j][2]=(Uint8)y;
            f[i][j][1]=(Uint8)u;
            f[i][j][0]=(Uint8)v;

        }

    }


}

void zig_zag(short int f[HEIGHT][WIDTH][3],short int *matrix){

    int i=0,p_x=0,p_y=0,j=0;
    int flag=0;

    for(i=0;i<WIDTH*HEIGHT*3;i+=3){
        
        *(matrix+i)=f[p_y][p_x][0];
        *(matrix+i+1)=f[p_y][p_x][1];
        *(matrix+i+2)=f[p_y][p_x][2];

        
        if(flag==0){
            p_x++,p_y--;
            if(p_y<0){
                p_y=0;
                flag=1;

            }
            if(p_x>WIDTH-1){
                p_x=WIDTH-1;
                p_y+=2;
                flag=1;


            }

        }
        else{
            p_x--,p_y++;
            if(p_y>HEIGHT-1){
                p_y=HEIGHT-1;
                p_x+=2;
                flag=0;

            }
            if(p_x<0){
                p_x=0;
                flag=0;
            }

        }


    }



}

void cuantizador(short int mat[HEIGHT][WIDTH][3]){
    short int luma[8][8]={{16,11,10,16,24,40,51,61},
                        {12,12,14,19,26,58,60,55},
                        {14,13,16,24,40,57,69,56},
                        {14,17,22,29,51,87,80,62},
                        {18,22,37,56,68,109,103,77},
                        {24,35,55,64,81,104,113,92},
                        {49,64,78,87,103,121,120,101},
                        {72,92,95,98,112,100,103,99}};
    short int croma[8][8]={{17,18,24,47,99,99,99,99},
                            {18,21,26,66,99,99,99,99},
                            {24,26,56,99,99,99,99,99},
                            {47,66,99,99,99,99,99,99},
                            {99,99,99,99,99,99,99,99},
                            {99,99,99,99,99,99,99,99},
                            {99,99,99,99,99,99,99,99},
                            {99,99,99,99,99,99,99,99}};
    int i=0,x_block,y_block,j;
    for(i=0;i<HEIGHT;i+=8){
        for(j=0;j<WIDTH;j+=8)
        for(x_block=i; x_block<i+8 ;x_block++){
            for(y_block=j; y_block<j+8 ;y_block++){
                mat[x_block][y_block][2]/=luma[x_block-i][y_block-j];
                mat[x_block][y_block][1]/=croma[x_block-i][y_block-j];
                mat[x_block][y_block][0]/=croma[x_block-i][y_block-j];
            }
        }
    }

}

void RLC (short int *matrix,short int acumulador [3]){

    int i,k=0,acum_y=0,acum_u=0,acum_v=0;
    short int y,u,v,y_ant=0,u_ant=0,v_ant=0,flag=0;
    short int cont[3]={1,1,1};
    acumulador[0]=0x0000;
    acumulador[1]=0x0000;
    acumulador[2]=0x0000;

    int index=0;
    for(i=0;i<WIDTH*HEIGHT*3;i+=3){

        y=*(matrix+i+2);
        u=*(matrix+i+1);
        v=*(matrix+i);

        
        if(y_ant==y){
            cont[0]++;
        }
        else{
            if(i==0){

            }
            else{

                acumulador[0]+=2;    
                cont[0]=1;
            }



        }

        if(u_ant==u){

            cont[1]++;


        }
        else{
            if(i==0){

            }
            else{

                acumulador[1]+=2;  
                cont[1]=1;
            }

        }

        if(v_ant==v){

            cont[2]++;

        }
        else{
            if(i==0){

            }
            else{

                
                acumulador[2]+=2;  
                cont[2]=1;
            }


        }
        y_ant=y;
        u_ant=u;
        v_ant=v;
    }
    
}

void RLC2 (short int *matrix,short int * temp1,short int * temp2, short int *temp3){

    int i,k=0,acum_y=0,acum_u=0,acum_v=0;
    short int y,u,v,y_ant=0,u_ant=0,v_ant=0,flag=0;
    int cont[3]={1,1,1};
    int cy=0,cu=0,cv=0;


    for(i=0;i<WIDTH*HEIGHT*3;i+=3){

        y=*(matrix+i+2);
        u=*(matrix+i+1);
        v=*(matrix+i);

        
        if(y_ant==y){
            cont[0]++;
        }
        else{
            if(i==0){

            }
            else{
                *(temp1+cy)=cont[0];
                *(temp1+cy+1)=y_ant;
                cy+=2;
  
                cont[0]=1;
            }



        }

        if(u_ant==u){

            cont[1]++;


        }
        else{
            if(i==0){

            }
            else{
                *(temp2+cu)=cont[1];
                *(temp2+cu+1)=u_ant;
                cu+=2;
                cont[1]=1;
            }

        }

        if(v_ant==v){

            cont[2]++;

        }
        else{
            if(i==0){

            }
            else{
                *(temp3+cv)=cont[2];
                *(temp3+cv+1)=v_ant;
                cv+=2;
                cont[2]=1;
            }


        }
        y_ant=y;
        u_ant=u;
        v_ant=v;
    }
    
}


