


/*
 * decoder.c
 *
 *  Created on: 5/7/2016
 *      Author: Miguel Ruiz García
        Company: University of Cantabria
        e-mail:mrg47@alumnos.unican.es
 */


#include <SDL.h>
#include <stdio.h>
#include "mbed.h"
#include "functions_dec.h"
#include "lora.h"
//#include "debug.h"
#define BPS 128000
#define BITS 8
#define STOP_BITS 1
 
//DigitalOut myled(LED1);

int main(int argc, char *argv[]){
    Serial pc(USBTX, USBRX);
    pc.baud(BPS);
    pc.format (BITS,SerialBase::None, STOP_BITS) ;

    int i=0,j=0,p_x=0,p_y=0,k=0;
    //myled=1;
    short int m[HEIGHT][WIDTH][3];
    short int *matriz=(short int *)malloc(sizeof(short int)*WIDTH*HEIGHT*3);
    short int index1,index2,index3;
    short int acumulador[3]={0,0,0};
int veces=0;

for(veces=0; veces < 30;veces++){
    short int *temp1,*temp2,*temp3;//these are vectors. Memory allocations are done at lora function.
    temp3=(short int *)malloc(sizeof(short int)*380);
    temp2=(short int *)malloc(sizeof(short int)*300);
    temp1=(short int *)malloc(sizeof(short int)*300);
//debug("lora\r\n");
    lora(temp1,index1,temp2,index2,temp3,index3,acumulador);//acumulador tells the length of the respective vector(acumulador[0] -> temp1,...)
    int indice=0;
  //  debug("paquete numero %i\r\n",veces+1);
    //We must "unroll" the vectors after being processed with the RLC (in the encoder)

/*    debug("return from lora function...\r\n");
    debug("acumulador[0]= %i\r\n",acumulador[0]);
    debug("acumulador[0]= %i\r\n",acumulador[1]);
    debug("acumulador[0]= %i\r\n",acumulador[2]);
    debug("Paquete numero %i\r\n",veces+1);*/
    k=0;
    short int acc1=0,acc2=0,acc3=0;
  for(i=0;i<acumulador[0]/2;i++){//Se divide entre 2 poque se cuentan por pares (longitud,valor).
        for(j=k;j<(*(temp1+indice)*3+k);j+=3){
        
            *(matriz+j)=*(temp1+indice+1);
            acc1++;
            if(j>HEIGHT*WIDTH*3) break;
            //debug("iteracion\r\n");
        }
        k=j;
        indice+=2;
         
    }
    for(i=(acc1-1)*3;i<HEIGHT*WIDTH*3;i++){
        *(matriz+i)=0;
        
    }
   
//debug("*(temp1+indice)= %i\r\n",*(temp1+0));
    indice=0;
    k=0;
    for(i=0;i<acumulador[1]/2;i++){

        for(j=k;j<(*(temp2+indice)*3+k);j+=3){
        
            *(matriz+j+1)=*(temp2+indice+1);
            acc2++;
            if(j>HEIGHT*WIDTH*3) break;
        }
        k=j;
        indice+=2;
    }
    for(i=(acc2-1)*3;i<HEIGHT*WIDTH*3;i++){
        *(matriz+i+1)=0;
    }
    
//debug("*(temp2+indice)= %i\r\n",*(temp2+indice));
    indice=0;
    k=0;
    for(i=0;i<acumulador[2]/2;i++){
        for(j=k;j<(*(temp3+indice)*3+k);j+=3){
       
            *(matriz+j+2)=*(temp3+indice+1);
            acc3++;
            if(j>HEIGHT*WIDTH*3) break;
        }
        k=j;
        indice+=2;
    }
    
    for(i=(acc3-1)*3;i<HEIGHT*WIDTH*3;i++){
        *(matriz+i+2)=0;
    }
    


    free(temp1);
    free(temp2);
    free(temp3);
    //debug("zig-zag\r\n");

    zig_zag_dec(m,matriz);
    //debug("acumulador\r\n");

    cuantizador_dec(m);
    

    //debug("idct\r\n");
    int matrix[8][8][3];
    for(i=0;i<HEIGHT;i+=8){
        for(j=0;j<WIDTH;j+=8){

            int k=0,l=0;

            for(k=i;k<i+8;k++){
                for(l=j;l<j+8;l++){


                    matrix[k-i][l-j][0]=m[k][l][0];
                    matrix[k-i][l-j][1]=m[k][l][1];
                    matrix[k-i][l-j][2]=m[k][l][2];
                }

            }

            IDCT(matrix,m,i,j);// i j índices de los pixeles en x e y del macrobloque

        }

    }


    int bpp=3;

/*    for(i=0;i<HEIGHT;i++){
        for(j=0;j<WIDTH;j++){
               
                if(m[i][j][0]>235) m[i][j][0]=235;
                if(m[i][j][1]>235) m[i][j][1]=235;
                if(m[i][j][2]>240) m[i][j][2]=240;

                if(m[i][j][0]<16) m[i][j][0]=16;
                if(m[i][j][1]<16) m[i][j][1]=16;
                if(m[i][j][2]<16) m[i][j][2]=16;
        }
    }*/
//debug("yuv\r\n");
    yuv_to_rgb(m);
    unsigned char var;
/*    for(i=0;i<HEIGHT;i++){
    for(j=0;j<WIDTH;j++){
         while(!pc.writeable());
         pc.printf("%c",(char)m[i][j][0]);
    }
}*/

    for(i=0;i<8;i++){
       for(j=0;j<320;j++){

               var=0xff & m[i][j][0];
                if(j>311){
                    while(!pc.writeable());
                    pc.printf("%c",(char)m[i][j-8][0]);
                
                
                    while(!pc.writeable());
                    pc.printf("%c",(char)m[i][j-8][1]);
                
                
                    while(!pc.writeable());
                    pc.printf("%c",(char)m[i][j-8][2]);
                }
                else{
                    while(!pc.writeable());
                    pc.printf("%c",(char)m[i][j][0]);
                
                
                    while(!pc.writeable());
                    pc.printf("%c",(char)m[i][j][1]);
                
                
                    while(!pc.writeable());
                    pc.printf("%c",(char)m[i][j][2]);
                }
                
                //var=255;

        
        }
    }
    
    while(!pc.writeable());
    pc.printf("2");//OJO con ponerlo aqui arriba
    
 
    char h;
    h=acc1&0xff;
    
    while(!pc.writeable());
    pc.printf("%c",h);
    
    h=(acc1>>8) & 0xff;
    
    while(!pc.writeable());
    pc.printf("%c",h);



    h=acc2&0xff;
    
    while(!pc.writeable());
    pc.printf("%c",h);
    
    h=(acc2>>8)&0xff;
    
    while(!pc.writeable());
    pc.printf("%c",h);
    
    
    h=acc3&0xff;
    
    while(!pc.writeable());
    pc.printf("%c",h);
    
    h=(acc3>>8)&0xff;
    
    while(!pc.writeable());
    pc.printf("%c",h);
 /*   char h;
    h=acumulador[0]&0xff;
    
    while(!pc.writeable());
    pc.printf("%c",h);
    
    h=(acumulador[0]>>8) & 0xff;
    
    while(!pc.writeable());
    pc.printf("%c",h);



    h=acumulador[1]&0xff;
    
    while(!pc.writeable());
    pc.printf("%c",h);
    
    h=(acumulador[1]>>8)&0xff;
    
    while(!pc.writeable());
    pc.printf("%c",h);
    
    
    h=acumulador[2]&0xff;
    
    while(!pc.writeable());
    pc.printf("%c",h);
    
    h=(acumulador[2]>>8)&0xff;
    
    while(!pc.writeable());
    pc.printf("%c",h);*/
}

    DigitalOut led(LED1);
    while(1){
        
        led=1;
        wait(0.5);
        led=0;
        wait(0.5);
    }
return 0;
}
