/*
 * functions_dec.h
 *
 *  Created on: 5/7/2016
 *      Author: Miguel Ruiz García
 */
#include <SDL.h>
//#include <windows.h>
#include <stdio.h>


#include <math.h>
#ifndef FUNCTIONS_DEC_H_
#define FUNCTIONS_DEC_H_



#endif /* FUNCTIONS_DEC_H_ */


#define PI 3.1415952
#define WIDTH 320
#define HEIGHT 8
#define DEPTH 32
#define RAIZ2 1.414214
#define PI16 0.19635

const float coeff[8][8]={
        {1.000, 0.980658, 0.923381, 0.830384, 0.705265, 0.552863, 0.379075, 0.190623},
        {1.000000, 0.830384, 0.379075, -0.200829, -0.712605, -0.982642, -0.919336, -0.544161},
        {1.000000, 0.552863, -0.388685, -0.982642, -0.697848, 0.211013, 0.931171, 0.818607},
        {1.000000, 0.190623, -0.927326, -0.544161, 0.719867, 0.818607, -0.407777, -0.974070},
        {1.000000, -0.200829, -0.919336, 0.570086, 0.690356, -0.847373, -0.350003, 0.987954},
        {1.000000, -0.561505, -0.369424, 0.976372, -0.727052, -0.159885, 0.906605, -0.858241},
        {1.000000, -0.836138, 0.398253, 0.170150, -0.682790, 0.971663, -0.942098, 0.603785},
        {1.000000, -0.982642, 0.931171, -0.847373, 0.734158, -0.595456, 0.436082, -0.261569} };

void IDCT(int matrix[8][8][3],short int f[HEIGHT][WIDTH][3],int p_fil,int p_col){
    int i=0,j=0,u,v;
    float cu=1,cv=1;
    int linea,bpp;

    Uint8 *pixel;


    for(i=p_fil;i<8+p_fil;i++){


        for(j=p_col;j<8+p_col;j++){
            f[i][j][0]=0;
            f[i][j][1]=0;
            f[i][j][2]=0;


            float dato=0.0;
            float dato2=0.0;
            float dato3=0.0;
            
            float acum0=0.0,acum1=0.0,acum2=0.0;

            for(u=0;u<8;u++){

                for(v=0;v<8;v++){
                    if(u==0){
                        cu=RAIZ2/2;
                    }
                    else cu=1.0;
                    if(v==0){
                        cv=RAIZ2/2;

                    }
                    else cv=1.0;
                    /*dato=(float)(cos((float)((((j-p_col)*2)+1)*v*PI16)));
                    dato2=(float)(cos((float)((((i-p_fil)*2)+1)*u*PI16)));*/
                    dato=coeff[j-p_col][v];//(float)(cos((float)((((j-p_col)*2)+1)*v*PI16)));
                    dato2=coeff[i-p_fil][u];//(float)(cos((float)((((i-p_fil)*2)+1)*u*PI16)));
                    dato3=(float)((cu*cv)/4);

                    acum0+=(float)(dato*dato2*(matrix[u][v][0]))*dato3;//crominancia
                    acum1+=(float)(dato*dato2*(matrix[u][v][1]))*dato3;//crominancia
                    acum2+=(float)(dato*dato2*(matrix[u][v][2]))*dato3;//luminancia

                }
            }
            
            f[i][j][0]=(short int)acum0;
            f[i][j][1]=(short int)acum1;
            f[i][j][2]=(short int)acum2;

        }


    }

}

void yuv_to_rgb(short int f[HEIGHT][WIDTH][3]){

    
    int i=0,j=0;

    float r=0.0,g=0.0,b=0.0;
   

    int cont;
  
    for(i=0;i<HEIGHT;i++){
        for(j=0;j<WIDTH;j++){



            b=(f[i][j][0])+(f[i][j][1]-128)*1.765;
            g=(f[i][j][0])-(f[i][j][2]-128)*0.711-(f[i][j][1]-128)*0.343;
            r=((f[i][j][0]))+((f[i][j][2])-128)*1.400;

        /*  r=(*(pixel+2)-16)*1.164+(*(pixel)-128)*1.793;
            g=(*(pixel+2)-16)*1.164-(*(pixel+1)-128)*0.213-(*(pixel)-128)*0.533;
            b=(*(pixel+2)-16)*1.164+((*(pixel+1))-128)*2.112;*/
            if(b>255) r=255;
            if(g>255) g=255;
            if(r>255) b=255;

            if(r<0) r=0;
            if(g<0) g=0;
            if(b<0) b=0;
            
            f[i][j][2]=(short int)r;
            f[i][j][1]=(short int)g;
            f[i][j][0]=(short int)b;
        }

    }


}

void zig_zag_dec(short int f[HEIGHT][WIDTH][3],short int *matrix){

    int i=0,p_x=0,p_y=0;
    int flag=0;
    for(i=0;i<HEIGHT*WIDTH*3;i+=3){

        f[p_y][p_x][0]= *(matrix+i);
        f[p_y][p_x][1]= *(matrix+i+1);
        f[p_y][p_x][2]= *(matrix+i+2);

        if(flag==0){
            p_x++,p_y--;
            if(p_y<0){
                p_y=0;
                flag=1;

            }
            if(p_x>WIDTH-1){
                p_x=WIDTH-1;
                p_y+=2;
                flag=1;


            }
        }
        else{
            p_x--,p_y++;
            if(p_y>HEIGHT-1){
                p_y=HEIGHT-1;
                p_x+=2;
                flag=0;

            }
            if(p_x<0){
                p_x=0;
                flag=0;
            }
        }


    }



}

void cuantizador_dec(short int mat[HEIGHT][WIDTH][3]){
    short int luma[8][8]={{16,11,10,16,24,40,51,61},
                        {12,12,14,19,26,58,60,55},
                        {14,13,16,24,40,57,69,56},
                        {14,17,22,29,51,87,80,62},
                        {18,22,37,56,68,109,103,77},
                        {24,35,55,64,81,104,113,92},
                        {49,64,78,87,103,121,120,101},
                        {72,92,95,98,112,100,103,99}};
    short int croma[8][8]={{17,18,24,47,99,99,99,99},
                            {18,21,26,66,99,99,99,99},
                            {24,26,56,99,99,99,99,99},
                            {47,66,99,99,99,99,99,99},
                            {99,99,99,99,99,99,99,99},
                            {99,99,99,99,99,99,99,99},
                            {99,99,99,99,99,99,99,99},
                            {99,99,99,99,99,99,99,99}};
    int i=0,x_block,y_block,j;
    for(i=0;i<HEIGHT;i+=8){
        for(j=0;j<WIDTH;j+=8)
        for(x_block=i; x_block<i+8 ;x_block++){
            for(y_block=j; y_block<j+8 ;y_block++){
                mat[x_block][y_block][0]*=luma[x_block-i][y_block-j];
                mat[x_block][y_block][1]*=croma[x_block-i][y_block-j];
                mat[x_block][y_block][2]*=croma[x_block-i][y_block-j];
            }
        }
    }

}


