#include "mbed.h"
#include "lora2.h"
#include "sx1276-hal.h"
#include "debug.h"
 
/* Set this flag to '1' to display debug messages on the console */
#define DEBUG_MESSAGE   0
 
/* Set this flag to '1' to use the LoRa modulation or to '0' to use FSK modulation */
#define USE_MODEM_LORA  1
#define USE_MODEM_FSK   !USE_MODEM_LORA
 
#define RF_FREQUENCY                                    868000000 // Hz
#define TX_OUTPUT_POWER                                 20        // 14 dBm
 
#if USE_MODEM_LORA == 1
 
    #define LORA_BANDWIDTH                              2         // [0: 125 kHz,
                                                                  //  1: 250 kHz,
                                                                  //  2: 500 kHz,
                                                                  //  3: Reserved]
    #define LORA_SPREADING_FACTOR                       7       // [SF7..SF12]
    #define LORA_CODINGRATE                             1         // [1: 4/5,
                                                                  //  2: 4/6,
                                                                  //  3: 4/7,
                                                                  //  4: 4/8]
    #define LORA_PREAMBLE_LENGTH                        8         // Same for Tx and Rx
    #define LORA_SYMBOL_TIMEOUT                         5         // Symbols
    #define LORA_FIX_LENGTH_PAYLOAD_ON                  false
    #define LORA_FHSS_ENABLED                           false  
    #define LORA_NB_SYMB_HOP                            4     
    #define LORA_IQ_INVERSION_ON                        false
    #define LORA_CRC_ENABLED                            true
    
#elif USE_MODEM_FSK == 1
 
    #define FSK_FDEV                                    25000     // Hz
    #define FSK_DATARATE                                19200     // bps
    #define FSK_BANDWIDTH                               50000     // Hz
    #define FSK_AFC_BANDWIDTH                           83333     // Hz
    #define FSK_PREAMBLE_LENGTH                         5         // Same for Tx and Rx
    #define FSK_FIX_LENGTH_PAYLOAD_ON                   false
    #define FSK_CRC_ENABLED                             true
    
#else
    #error "Please define a modem in the compiler options."
#endif
 
#define RX_TIMEOUT_VALUE                                9500000   // in us
#define BUFFER_SIZE                                     32        // Define the payload size here
 
#if( defined ( TARGET_KL25Z ) || defined ( TARGET_LPC11U6X ) )
DigitalOut led(LED2);
#else
DigitalOut led(LED1);
#endif
 
/*
 *  Global variables declarations 
 */
typedef enum
{
    LOWPOWER = 0,
    IDLE,
    
    RX,
    RX_TIMEOUT,
    RX_ERROR,
    
    TX,
    TX_TIMEOUT,
    
    CAD,
    CAD_DONE
}AppStates_t;
 
volatile AppStates_t State = LOWPOWER;
 
/*!
 * Radio events function pointer
 */
static RadioEvents_t RadioEvents;
 
/*
 *  Global variables declarations
 */
SX1276MB1xAS Radio( NULL );
 
const uint8_t PingMsg[] = "PING";
const uint8_t PongMsg[] = "PONG";
 

const uint8_t AckMsg[] = "ACK";
const uint8_t EOPMsg[] = "EOP";
const uint8_t RfSMsg[] = "RfS";
const uint8_t InitMsg[] = "INIT";
const uint8_t PaqMsg[] = "\t\n";

int py=0,pu=0,pv=0,py2=0,pu2=0,pv2=0;
int py_ant=0,pu_ant=0,pv_ant=0;
int flag_y=0,flag_u=0,flag_v=0;
short int length_y=0,length_u=0,length_v=0;
uint16_t BufferSize = BUFFER_SIZE;
uint8_t Buffer[BUFFER_SIZE];
//uint8_t Buffer2[4];
int init=0;
int16_t RssiValue = 0.0;
int8_t SnrValue = 0.0;
short int init_packet=0;
int start=0;
bool first_y=true,first_u=true,first_v=true;
 
void lora(short int *temp1,short int index1,short int *temp2,short int index2,short int *temp3,short int index3,short int acumulador[3])
{
    uint8_t i;
    bool isMaster = false;
    
    //debug( "\n\n\r     SX1276 JPEG Compressor Application \n\n\r" );
 
    // Initialize Radio driver
    RadioEvents.TxDone = OnTxDone;
    RadioEvents.RxDone = OnRxDone;
    RadioEvents.RxError = OnRxError;
    RadioEvents.TxTimeout = OnTxTimeout;
    RadioEvents.RxTimeout = OnRxTimeout;
    Radio.Init( &RadioEvents );
    
    // verify the connection with the board
    while( Radio.Read( REG_VERSION ) == 0x00  )
    {
        debug( "Radio could not be detected!\n\r", NULL );
        wait( 1 );
    }
            
    //debug_if( ( DEBUG_MESSAGE & ( Radio.DetectBoardType( ) == SX1276MB1LAS ) ) , "\n\r > Board Type: SX1276MB1LAS < \n\r" );
    //debug_if( ( DEBUG_MESSAGE & ( Radio.DetectBoardType( ) == SX1276MB1MAS ) ) , "\n\r > Board Type: SX1276MB1MAS < \n\r" );
    
    Radio.SetChannel( RF_FREQUENCY ); 
 
#if USE_MODEM_LORA == 1
    
    //debug_if( LORA_FHSS_ENABLED, "\n\n\r             > LORA FHSS Mode < \n\n\r");
    //debug_if( !LORA_FHSS_ENABLED, "\n\n\r             > LORA Mode < \n\n\r");
 
    Radio.SetTxConfig( MODEM_LORA, TX_OUTPUT_POWER, 0, LORA_BANDWIDTH,
                         LORA_SPREADING_FACTOR, LORA_CODINGRATE,
                         LORA_PREAMBLE_LENGTH, LORA_FIX_LENGTH_PAYLOAD_ON,
                         LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP, 
                         LORA_IQ_INVERSION_ON, 2000000 );
    
    Radio.SetRxConfig( MODEM_LORA, LORA_BANDWIDTH, LORA_SPREADING_FACTOR,
                         LORA_CODINGRATE, 0, LORA_PREAMBLE_LENGTH,
                         LORA_SYMBOL_TIMEOUT, LORA_FIX_LENGTH_PAYLOAD_ON, 0,
                         LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP, 
                         LORA_IQ_INVERSION_ON, true );
                         
#elif USE_MODEM_FSK == 1
 
    //debug("\n\n\r              > FSK Mode < \n\n\r");
    Radio.SetTxConfig( MODEM_FSK, TX_OUTPUT_POWER, FSK_FDEV, 0,
                         FSK_DATARATE, 0,
                         FSK_PREAMBLE_LENGTH, FSK_FIX_LENGTH_PAYLOAD_ON,
                         FSK_CRC_ENABLED, 0, 0, 0, 2000000 );
    
    Radio.SetRxConfig( MODEM_FSK, FSK_BANDWIDTH, FSK_DATARATE,
                         0, FSK_AFC_BANDWIDTH, FSK_PREAMBLE_LENGTH,
                         0, FSK_FIX_LENGTH_PAYLOAD_ON, 0, FSK_CRC_ENABLED,
                         0, 0, false, true );
                         
#else
 
#error "Please define a modem in the compiler options."
 
#endif
     
    //debug_if( DEBUG_MESSAGE, "Starting image transmission loop\r\n" ); 
        
    led = 0;
    flag_y=0,flag_u=0,flag_v=0;
    int finish=0;
    first_y=true,first_u=true,first_v=true;
    Radio.Rx( RX_TIMEOUT_VALUE );
    
    while( 1 )
    {
        switch( State )
        {
        case RX:
            if( isMaster == true )
            {
                if( BufferSize > 0 )
                {
                    if( strncmp( ( const char* )Buffer, ( const char* )AckMsg, 3 ) == 0 )
                    {
                        led = !led;
                        //debug( "...Ack RX\r\n" );

                        Buffer[0]='\t';
                        Buffer[1]='\n';
                        //index1=20;index2=20;index3=20;
                        int pointer=0;
                        for(pointer=2;pointer<BufferSize;pointer+=2){
                    
                            if(flag_y==0) {//se comprueba si se ha cargado en el buffer de transmisión cada una de las componentes
                                if(first_y == true) {//en primer lugar se manda la longitud de la componente y u v 
                                    Buffer[pointer]=index1&0xff;//Se carga la parte baja del short int y en el siguiente byte se carga la parte alta.
                                    Buffer[pointer+1]=(index1>>8)&0xff;
      //                              debug("%c %c \r\n",Buffer[pointer],Buffer[pointer+1]);
                                    first_y = false;
                                    
                                     //debug( "transmitting y length...\r\n" );
                                }
                                 else{
                                    Buffer[pointer]=*(temp1+py) & 0x00ff;
                                    Buffer[pointer+1]=(*(temp1+py)>>8) & 0x00ff;
                                    py++;
                                    //debug( "transmitting y data..\r\n" );
                                    if(py >= index1) {
                                    
                                        flag_y=1;
                                        break;
                                        //Buffer[pointer+2]='\t';
                                        //pointer+=2;
                                    }
                                }
                            }
                            else if(flag_u==0){
                                if(first_u == true) {
                                    Buffer[pointer]=index2&0xff;
                                    Buffer[pointer+1]=(index2>>8)&0xff;
                                    first_u = false;
                                    //debug( "transmitting u length...\r\n" );
                                }
                                else{
                                
                                    Buffer[pointer]=*(temp2+pu) & 0x00ff;
                                    Buffer[pointer+1]=(*(temp2+pu)>>8) & 0x00ff;
                                    pu++;
                                    //debug( "transmitting u data...\r\n" );
                                    if(pu>= index2) {
                                        flag_u=1;
                                        //Buffer[pointer+2]='\t';
                                        //pointer+=2;
                                        break;
                                    }
                                }
                            }
                        
                            else{
                                if(first_v == true) {
                                    Buffer[pointer]=index3&0xff;
                                    Buffer[pointer+1]=(index3>>8)&0xff;
                                    first_v = false;
                                    //debug( "transmitting v length...\r\n" );
                                }
                                else{
                                    Buffer[pointer]=*(temp3+pv) & 0x00ff;
                                    Buffer[pointer+1]=(*(temp3+pv)>>8) & 0x00ff;
                                    pv++;
                                    //debug( "transmitting v data ...\r\n" );
                                    if(pv >= index3) {
                                        flag_v=1;
                                        //Buffer[pointer+2]='\n';//salto de línea es EOT  
                                        //pointer+=2;
                                        break;
                                    }
                                }
                            }
                        
                        
                        }
                    
                    //debug( "end of cycle..\r\n" );
                    int finish=0;
                    if(flag_y==1 && flag_u==1 && flag_v==1){
                        //Buffer[pointer]='\n';//salto de línea es EOT  
                        flag_y=0;flag_u=0;flag_v=0;
                        //debug( "finished transmission ...\r\n" );
                        first_y=true;first_u=true;first_v=true;
                        finish=1;
                        

                    }
                    else{
                        for( i = pointer; i < BufferSize; i++ )
                        {
                            Buffer[i] = i - 4;
                        }
                        
                    }

                

                    wait_ms( 10 );                
                    //debug( "Sending packet...\r\n" );
                    Radio.Send( Buffer, BufferSize );
                    if(finish==1) goto end;
                    }

                    else // valid reception but neither a PING or a PONG message
                    {    // Set device as master ans start again
                        isMaster = true;
                        Radio.Rx( RX_TIMEOUT_VALUE );
                    }    
                }
            }
            else
            {
                if( BufferSize > 0 )
                {
                    if( strncmp( ( const char* )Buffer, ( const char* )InitMsg, 4 ) == 0 )
                    {
                        led = !led;
    //                    debug( "...Init received gfd\r\n" );
                                    short int num=0;
                                    num=0xff & Buffer[5];
                                    num=num<<8;
                                    num=num | (Buffer[4] & 0xff);
  //                                  debug( "py = %i\r\n",num );
                                    
                                    py=num;
                                    
                                    num=0;
                                    num=0xff & Buffer[7];
                                    num=num<<8;
                                    num=num | (Buffer[6] & 0xff);
  //                                  debug( "pu = %i\r\n",num );
                                    pu=num;
                        num=0;
                                    num=0xff & Buffer[9];
                                    num=num<<8;
                                    num=num | (Buffer[8] & 0xff);
  //                                  debug( "pv = %i\r\n",num );
                                    
                                    pv=num;
                                    //py=py_ant;pu=pu_ant;pv=pv_ant;
                                    
                                    if(pv<=0) {
                                       flag_v=0;
                                       first_v=true;
                                       pv=0;
                                    }
                                    if(pu<=0) {
                                       flag_u=0;
                                       first_v=true;
                                       pu=0;
                                    }
                                    if(py<=0) {
                                       flag_y=0;
                                       first_v=true;
                                       py=0;
                                    }
                                    
                        
                        // Send the reply to the PING string
                        strcpy( ( char* )Buffer, ( char* )AckMsg );
                        // We fill the buffer with numbers for the payload 
                        for( i = 3; i < BufferSize; i++ )
                        {
                            Buffer[i] = i - 4;
                        }
                        wait_ms( 10 );  
                        Radio.Send( Buffer, BufferSize );
                    }
                    else if( strncmp( ( const char* )Buffer, ( const char* )PaqMsg, 2 ) == 0 )
                    { // A master already exists then become a slave
                        
  //                      debug( "...Receiving data TX \r\n" );
                        led = !led;
                         int pointer=0;
                            py_ant=py;
                            pu_ant=pu;
                            pv_ant=pv;
                                               
                        
                        for(pointer=2;pointer<BufferSize;pointer+=2){
                        if(flag_y==0) {//se comprueba si se ha cargado en el buffer de transmisión cada una de las componentes
                            if(first_y == true) {//EL PRIMER DATO ES LA LONGITUD
                                length_y=0xff & Buffer[pointer+1];
                                length_y=length_y<<8;
                                length_y=length_y | (Buffer[pointer] & 0xff);
                                first_y = false;

                                acumulador[0]=length_y;
  //                              debug("length_y = %i \r\n",length_y);
                            }
                            else{
                                //if(Buffer[pointer]!='\t'){//VERIFY the character is not EOC (end of component y u v)
                        
                                    short int num=0;
                                    num=0xff & Buffer[pointer+1];
                                    num=num<<8;
                                    num=num | (Buffer[pointer] & 0xff);
                                    *(temp1+py)=num;
                                    py++;
                                    
  //                                  debug("valor py = %i \r\n",py);
  //                                  debug("num = %i \r\n",num);
                                    if (py >= length_y) {
                                        flag_y=1;
                                        //acumulador[0]=py;
  //                                      debug("valor py = %i \r\n",py);
                                        break;
                                    }
                                    

                                     
                                    //if all bytes of the component are read -> flag raised
                                     //originally designed with goto.

                           }
                        }
                            
                       
                        else if(flag_u==0){
                            if(first_u == true) {
                                length_u=0xff & Buffer[pointer+1];
                                length_u=length_u<<8;
                                length_u=length_u | (Buffer[pointer] & 0xff);
                                acumulador[1]=length_u;
                                first_u = false;
                                
  //                              debug("length_u = %i \r\n",length_u);
                            }
                            else{
                                
                        
                                    short int num=0;
                                    num=0xff & Buffer[pointer+1];
                                    num=num<<8;
                                    num=num | (Buffer[pointer] & 0xff);
                                    *(temp2+pu)=num;
                                    pu++;
  //                                  debug("valor pu = %i \r\n",pu);
  //                                  debug("num = %i \r\n",num);
                                    if (pu >= length_u) {
                                        flag_u=1;
                                         //acumulador[1]=pu;
                                        break;
                                    }
                                    


                            }
                        }
                        
                        else{
                            if(first_v == true) {
                                length_v=0xff & Buffer[pointer+1];
                                length_v=length_v<<8;
                                length_v=length_v | (Buffer[pointer] & 0xff);
                                acumulador[2]=length_v;
                                first_v = false;
                               
  //                              debug("length_v = %i \r\n",length_v);
                                
                                
                            }
                            else{
                                //if(Buffer[pointer]!='\n'){//VERIFY the character is not EOT
                        
                                    short int num=0;
                                    num=0xff & Buffer[pointer+1];
                                    num=num<<8;
                                    num=num | (Buffer[pointer] & 0xff);
                                    *(temp3+pv)=num;
                                    pv++;
  //                                  debug("valor pv = %i \r\n",pv);
  //                                  debug("num = %i \r\n",num);
                                    if (pv >= length_v) {
                                        flag_v=1;
                                        //acumulador[2]=pv;
                                        break;}
                                    


                            }
                        }
         
                        
                    }
                    if(flag_y==1 && flag_u==1 && flag_v ==1){ 
                        py=0;pu=0;pv=0;
                        //py_ant=0;pu_ant=0;pv_ant=0;
                        //flag_y=0;flag_u=0;flag_v=0;
                        //first_y=true;first_u=true;first_v=true;
                        
  //                      debug( "Packet received (final de imagen)\r\n" );

                        State = LOWPOWER;
                        //goto end;
                        finish=1;       
                                     
                       
                    }
                        
                        strcpy( ( char* )Buffer, ( char* )AckMsg );
                        // We fill the buffer with numbers for the payload 
                            for( i = 4; i < 32; i++ )
                            {
                            Buffer[i] = i - 4;
                            }
                        wait_ms( 10 );  

  //                      debug( "Packet received \r\n" );
                        Radio.Send( Buffer, BufferSize );
                        if(finish==1) {
                            py_ant=0;pu_ant=0;pv_ant=0;
                            flag_y=0;flag_u=0;flag_v=0;
                            first_y=true;first_u=true;first_v=true;
                            goto end;
                        }
                    }
                    else // valid reception but not a PAQ or init as expected (Request for send)
                    {    // Set device as master and start again
                        //isMaster = true;

                        strcpy( ( char* )Buffer, ( char* )AckMsg );
                        // We fill the buffer with numbers for the payload 
                            for( i = 4; i < 32; i++ )
                            {
                            Buffer[i] = i - 4;
                            }
                        wait_ms( 10 );  

  //                      debug( "RfS received \r\n" );
                        Radio.Send( Buffer, BufferSize );
                        
                    }   
                                    
                        

                }
            }
            State = LOWPOWER;
            break;
        case TX:    
            led = !led; 
            if( isMaster == true )  
            {
                
                //debug( "Iransmitting packet TX...\r\n" );
            }
            else
            {
  //              debug( "ACK RX...\r\n" );
                
            }
            Radio.Rx( RX_TIMEOUT_VALUE );
            State = LOWPOWER;
            break;
        case RX_TIMEOUT:
            if( isMaster == true )
            {
                
                strcpy( ( char* )Buffer, ( char* )InitMsg );
                for( i = 4; i < BufferSize; i++ )
                {
                    Buffer[i] = i - 4;
                }
                wait_ms( 10 ); 
                Radio.Send( Buffer, BufferSize );
                //debug("start!\r\n");//empezamos aqui
            }
            else
            {
  //              debug("RX_TIMEOUT... \r\n");
                wait(3);
                /*strcpy( ( char* )Buffer, ( char* )AckMsg );
                for( i = 4; i < BufferSize; i++ )
                {
                    Buffer[i] = i - 4;
                }
                wait_ms( 10 ); 
                Radio.Send( Buffer, BufferSize );  */
                Radio.Rx( RX_TIMEOUT_VALUE );
            }             
            State = LOWPOWER;
            break;
        case RX_ERROR:
            // We have received a Packet with a CRC error, send reply as if packet was correct
            if( isMaster == true )
            {
                // Send the next PING frame
                strcpy( ( char* )Buffer, ( char* )InitMsg );
                for( i = 4; i < BufferSize; i++ )
                {
                    Buffer[i] = i - 4;
                }
                wait_ms( 10 );  
                Radio.Send( Buffer, BufferSize );
            }
            else
            {
                // Send the next PONG frame
  //              debug("CRC ERROR... \r\n");
                //wait(3);


                /*while(1){
                    led=!led;
                    wait(1);
                }*/
                const uint8_t RfSY[] = "RfSy";
                const uint8_t RfSU[] = "RfSu";
                const uint8_t RfSV[] = "RfSv";
                
                        if(py < acumulador[0]) {
 //                           debug("sent RFSY message \r\n");
                            strcpy( ( char* )Buffer, ( char* )RfSY );

                                       
                        }
                        else if(pu < acumulador[1]) {
 //                           debug("sent RFSu message \r\n");
                            strcpy( ( char* )Buffer, ( char* )RfSU );

                                       
                        }
                        else {
 //                           debug("sent RFSV message \r\n");
                            strcpy( ( char* )Buffer, ( char* )RfSV );
                            

                                       
                        }
                for( i = 4; i < BufferSize; i++ )
                {
                    Buffer[i] = i - 4;
                }
                wait_ms( 10 );  
                Radio.Send( Buffer, BufferSize );
            }
            State = LOWPOWER;
            break;
        case TX_TIMEOUT:
            Radio.Rx( RX_TIMEOUT_VALUE );
            State = LOWPOWER;
            break;
        case LOWPOWER:
            break;
        default:
            State = LOWPOWER;
            break;
        }    
    }
    end:
    int a;
}
 
void OnTxDone( void )
{
    Radio.Sleep( );
    State = TX;
    debug_if( DEBUG_MESSAGE, "> OnTxDone\n\r" );
}
 
void OnRxDone( uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr)
{
    Radio.Sleep( );
    BufferSize = size;
    memcpy( Buffer, payload, BufferSize );
    RssiValue = rssi;
    SnrValue = snr;
    State = RX;
    debug_if( DEBUG_MESSAGE, "> OnRxDone\n\r" );
}
 
void OnTxTimeout( void )
{
    Radio.Sleep( );
    State = TX_TIMEOUT;
    debug_if( DEBUG_MESSAGE, "> OnTxTimeout\n\r" );
}
 
void OnRxTimeout( void )
{
    Radio.Sleep( );
    Buffer[ BufferSize ] = 0;
    State = RX_TIMEOUT;
    debug_if( DEBUG_MESSAGE, "> OnRxTimeout\n\r" );
}
 
void OnRxError( void )
{
    Radio.Sleep( );
    State = RX_ERROR;
    debug_if( DEBUG_MESSAGE, "> OnRxError\n\r" );
}

