//
// for strawberry-linux.com's "lpclcd" 11U24 Board
// https://strawberry-linux.com/catalog/items?code=12014
//
#include "mbed.h"
#include "I2cLCD.h"

// SW,LED,PULLUP
// P0_1  : USER SW (ISP)
// P0_6  : LED
// P0_23 : I2C PULLUP

//
// I2C LCD SlaveAddress = 0x7c 
//  SlaveAddress , commands and the initialize sequence are almost 
//  same as "i2c low voltage lcd module" by strawberry-linux. 
//  (http://strawberry-linux.com/catalog/items?code=27001)
//
//  So I2cLCD library seems to work well.
//
// P0_25 : RESET
// P0_4  : SCL
// P0_5  : SDA
// P1_3  : LCD BACKLIGHT
//

DigitalIn sw(P0_1);
DigitalOut backlight(P1_3);
DigitalOut led(P1_6); // The manual says "P0_6" but schematic is "P1_6"
I2cLCD lcd(P0_5, P0_4,P0_25);
Ticker timer;

int count = 0 ;

void attime()
{
    lcd.locate(0,0);
    lcd.printf("Hello World! %d\r\n",count);
    led = !led;
    count++ ;
} 

int main() 
{
    backlight = 0;
    timer.attach(&attime, 1);
    while(1)
    {
    }
}
