// p30 : TRG IN (Interrupt In)
// p13 : TRG OUT (Digital Out)
#include "mbed.h"

Serial pc(USBTX,USBRX) ;
Serial zw(p9,p10) ;
InterruptIn TRG(p30) ;
DigitalOut TRG_OUT(p13) ;
DigitalOut led1(LED1),led2(LED2),led3(LED3),led4(LED4);
Ticker timer ;

volatile int edgectr = 0;
volatile int onctr = 0 ;
volatile int state = 0 ;
volatile int nowtrg = 0 ;

void timer1ms()
{
    if (onctr > 0) {
        onctr++;
    }
}

void trgon()
{
    edgectr++ ;
    if (onctr == 0) {
        onctr++ ;
    }
}

char zwrxbuf[1024] = "---------------------------" ;
int zwrxctr = 0;

char sendbuf[] = "************" ;

int main() {
    pc.baud(115200) ;
    zw.baud(115200) ;
    TRG.mode(PullUp) ; 
  TRG.fall(trgon);
    timer.attach(timer1ms,0.001) ; // 1ms
    while(1)
    {
        if (onctr > 0) {
            if (onctr >= 20) {
                onctr = 0 ;
                led4 = !led4 ;
                pc.printf("%d,%s\r\n",edgectr,sendbuf) ;
            } else if (onctr >= 10) {
                TRG_OUT = 0 ;   
            }   else {
                TRG_OUT = 1 ;
            }
        }
        
        if (pc.readable()) {
            if (pc.getc() == '*') {
                edgectr = 0 ;
                for(int i=0;i<sizeof(sendbuf)-1;i++) {
                    sendbuf[i] = '*' ;
                }
                pc.printf("%d,%s\r\n",edgectr,sendbuf) ;
            }
        }
        
        // read zw
        if (zw.readable()) {
            int c = zw.getc() ;
            if (c != 0x0D) {
                zwrxbuf[zwrxctr] = c ;
                zwrxctr = (zwrxctr + 1) & 0xFF ;
                led3 = !led3 ;
            } else {
                // copy
                for(int i=0;i<sizeof(sendbuf)-1;i++) {
                    sendbuf[i] = zwrxbuf[i] ;
                }
                // reset
                zwrxctr = 0 ;
                led2 = !led2 ;
            }
        }
    }
}
