//
// SPILCD_QVGA -- mio
// This code is based on http://mbed.org/users/Sim/programs/SPILCDsample
//
// 2010/06/16 - Now Supports only "LGDP4531" and screen fill test "filltest()" command only (Alpha level).
//

#ifndef __SPILCD_QVGA_H__
#define __SPILCD_QVGA_H__

#include "mbed.h"

typedef unsigned int u32 ;
typedef unsigned short u16 ;
typedef unsigned char u8 ;

class SPILCD_QVGA {
private:
    int rs,rw;

    DigitalOut cs, rst;
    SPI spi;
    Serial pc;

    void reset(u16 data) {
        rst = data ;
    }

    void csout(u16 data) {
        if (data == 0) {
            cs = 0 ;
// debug
//            pc.printf("[") ;
        } else {
            cs = 1 ;
// debug
//            pc.printf("]\r\n") ;
        }
    }

    void DataToWriteBegin(void) {
        u8 d ;
        d = (0x70 | (rs ? 0x02 : 0x00) | (rw ? 0x01 : 0x00)) ;
        spi.write(d) ;
// debug
//        pc.printf("%02X",d) ;
    }

    u16 DataToWrite16(u16 data) {
        u8 hiout,loout ;
        u8 hi,lo ;
        hiout = (u8)((data & 0xFF00) >> 8) ;
        hi = spi.write(hiout);
// debug
//         pc.printf("%02X",hi) ;
        loout = ((u8)(data & 0x00FF)) ;
        lo = spi.write(loout);
// debug
//        pc.printf("%02X",lo) ;
        return (u16)((hi << 8) + lo) ;
    }

    void DataToWrite(u16 data) {
        DataToWriteBegin() ;
        DataToWrite16(data) ;
    }

    u16 DataToRead(u16 dummy) {
        rw = 1 ;
        DataToWriteBegin() ;
        rw = 0 ;
        // spi.write(0x00) ; // dummy 1 byte read ??
        return DataToWrite16(dummy) ;
    }

    void LCD_WR_REG(u16 Index,u16 CongfigTemp) {
        csout(0) ;
        rs = 0 ;
        DataToWrite(Index);
        csout(1) ;
        wait_us(1);
        csout(0) ;
        rs = 1 ;
        DataToWrite(CongfigTemp);
        csout(1) ;
    }

    u16 LCD_RD_REG(u16 Index) {
        u16 result ;
        csout(0) ;
        rs = 0 ;
        DataToWrite(Index);
        csout(1) ;
        wait_us(1);
        csout(0) ;
        rs = 1 ;
        result = DataToRead(0x0000);
        csout(1) ;
        return result ;
    }


    void Lcd_WR_Start(void) {
        csout(0) ;
        rs = 0 ;
        DataToWrite(0x0022);
        csout(1) ;
        wait_us(1);
        csout(0) ;
        rs = 1 ;
    }

    void Lcd_SetCursor(u16 x,u16 y) {
        LCD_WR_REG(0x20,x);
        LCD_WR_REG(0x21,y);
    }

    // boot up sequence
    void init() {
        u16 i ;
        spi.format(8,3); // SPI mode = 3
        spi.frequency(4000000);

        // reset
        reset(1);
        wait_ms(200);
        reset(0);
        wait_ms(200);
        reset(1);

        // initialize sequence
        DataToWrite16(0xffff);
        wait_ms(10);
        LCD_WR_REG(0x0000,0x0001);
        wait_ms(10);

        u16 id = LCD_RD_REG(0x0000) ;           // CHECK LCD TYPE (ID READ)
        pc.printf("CHIP ID=%04X\r\n",id) ;

        if (id == 0x4531) {
            csout(0);
            DataToWrite16(0x0);
            DataToWrite16(0x0);
            csout(1);
            wait_ms(10);
            
            // Setup display
            LCD_WR_REG(0x10,0x0628);
            LCD_WR_REG(0x12,0x0006);
            LCD_WR_REG(0x13,0x0A32);
            LCD_WR_REG(0x11,0x0040);
            LCD_WR_REG(0x15,0x0050);
            LCD_WR_REG(0x12,0x0016);
            wait_ms(15);
            LCD_WR_REG(0x10,0x5660);
            wait_ms(15);
            LCD_WR_REG(0x13,0x2A4E);

            LCD_WR_REG(0x01,0x0100);
            LCD_WR_REG(0x02,0x0300);
            LCD_WR_REG(0x03,0x1038);

            LCD_WR_REG(0x08,0x0202);
            LCD_WR_REG(0x09,0x0000);
            LCD_WR_REG(0x0A,0x0000);
            LCD_WR_REG(0x0C,0x0001); // 16bit , Internal

            LCD_WR_REG(0x30,0x0000);
            LCD_WR_REG(0x31,0x0402);
            LCD_WR_REG(0x32,0x0106);
            LCD_WR_REG(0x33,0x0700);
            LCD_WR_REG(0x34,0x0104);
            LCD_WR_REG(0x35,0x0301);
            LCD_WR_REG(0x36,0x0707);
            LCD_WR_REG(0x37,0x0305);
            LCD_WR_REG(0x38,0x0208);
            LCD_WR_REG(0x39,0x0F0B);
            wait_ms(15);
            LCD_WR_REG(0x41,0x0002);
            LCD_WR_REG(0x60,0x2700);
            LCD_WR_REG(0x61,0x0001);
            LCD_WR_REG(0x90,0x0119);
            LCD_WR_REG(0x92,0x010A);
            LCD_WR_REG(0x93,0x0004);
            LCD_WR_REG(0xA0,0x0100);
            LCD_WR_REG(0x07,0x0001);
            wait_ms(15);
            LCD_WR_REG(0x07,0x0021);
            wait_ms(15);
            LCD_WR_REG(0x07,0x0023);
            wait_ms(15);
            LCD_WR_REG(0x07,0x0033);
            wait_ms(15);
            LCD_WR_REG(0x07,0x0133);
            wait_ms(20);
            LCD_WR_REG(0xA0,0x0000);
            wait_ms(20);
        } else {
            pc.printf("UNKNOWN LCD\r\n") ;
        }
    }

public:

    // constructor
    SPILCD_QVGA(PinName cs_pin, PinName rst_pin, PinName mosi_pin, PinName miso_pin, PinName sclk_pin,PinName tx_pin,PinName rx_pin)
            : cs(cs_pin), rst(rst_pin), spi(mosi_pin, miso_pin, sclk_pin),pc(tx_pin,rx_pin) {
        rw = 0 ;
        rs = 0 ;
        init() ;
    }

    // wipe all screen
    void filltest(u16 Color) {
        u32 temp;
        u16 x,y ;
        Lcd_SetCursor(0,0);
        Lcd_WR_Start();
        rs = 1 ;
        for (x = 0;x < 240;x++) {
            for (y = 0;y < 320;y++) {
//                Lcd_SetCursor(x,y);
//                LCD_WR_REG(0x22,Color);            
                csout(0) ;
                DataToWrite(Color);
                csout(1) ;
                Color++ ;
            }
        }
        rs = 0 ;
    }
};

#endif
