#include "mbed.h"
#include "C12832_lcd.h"
#include "Arial24x23.h"

Ticker t ;
C12832_LCD lcd;
PwmOut buzzer(p26);
InterruptIn left(p13),right(p16),center(p14);
DigitalOut l1(LED1),l2(LED2),l3(LED3),l4(LED4);

int last = 180;
int i = 0 ;


void printlast(){
    lcd.invert(0);
    lcd.locate(8,2);
    lcd.printf(" %02d:%02d ",(int)last/60,(int)last%60);
}


void pushleft() {
    if (last > 10) {
        last-=10 ;
    }
    printlast();
}

void pushright() {
    last+=10 ;
    printlast();
}

void pushcenter() {
    buzzer = 0;
}

void onesec()
{
    if (last > 0) {
        l1 = l2 = l3 = l4 = 0 ;
        buzzer = 0 ;
        if (--last == 0) {
            buzzer = 0.5;
        }
        printlast();
    } else {
        lcd.invert(i);
        l1 = l3 = i ;
        i = i ? 0 : 1 ;
        l2 = l4 = i ;
    }
}

int main()
{
    buzzer = 0 ;
    lcd.cls();
    lcd.set_font((unsigned char *)Arial24x23);
    l1 = 0 ;
    l2 = 0 ;
    left.rise(&pushleft);
    right.rise(&pushright);
    center.rise(&pushcenter);
    buzzer.period_us(1000);    
    t.attach(&onesec,1.0);

    while(true) {   // this is the third thread
        sleep();
    }
}
