//
// OV7670 + FIFO AL422B camera board test
//
#include "mbed.h"
#include "spilcd_qvga.h"
#include "ov7670.h"
#include <stdlib.h>

//
// SPILCD LG 
//
SPILCD_QVGA lcd(p29, p30, p5, p6, p7) ;
OV7670 camera(
    p28,p27,       // SDA,SCL(I2C / SCCB)
    p21,p22,p20,   // VSYNC,HREF,WEN(FIFO)
    //p18,p17,p16,p15,p11,p12,p14,p13, // D7-D0
    Port0,0x07878000,
    p23,p24,p25) ; // RRST,OE,RCLK

Serial pc(USBTX,USBRX) ;
Timer t;

#undef QQVGA

#ifdef QQVGA
# define SIZEX (160)
# define SIZEY (120)
#else
# define SIZEX (320)
# define SIZEY (240)
#endif

int main() {
    int last ;
    pc.baud(115200) ;
    camera.Reset() ;

#ifdef QQVGA
    camera.InitQQVGA565(true,false) ;
#else
    camera.InitQVGA565(true,false) ;
#endif

    // CAPTURE and SEND LOOP
    t.start();
    last = t.read_ms() ;
    while(1)
    {
        camera.CaptureNext() ;
        while(camera.CaptureDone() == false) ;
        printf("Caputure %d(ms)\r\n", t.read_ms() - last) ;
        last = t.read_ms() ;
        camera.ReadStart() ;
        lcd.Lcd_SetCursor(0,0);
        lcd.Lcd_WR_Start();
        lcd.rsout(1) ;
        for (int y = 0;y < SIZEY;y++) {
            lcd.Lcd_SetCursor(y,0);
            lcd.Lcd_WR_Start();
            for (int x = 0;x < SIZEX;x++) {
                lcd.csout(0) ;
                lcd.DataToWrite(camera.ReadOneWord());
                lcd.csout(1) ;
            }
        }
        camera.ReadStop() ; 
        lcd.rsout(0) ;
        printf("FIFO Read & Lcd Out %d(ms)\r\n", t.read_ms() - last) ;
        last = t.read_ms() ;
    }
}
