/**
 * MbedFileServer , LPC1768-MiniDK2 Port
 *
 * See:
 *  https://mbed.org/users/nyatla/code/libMiMic/
 *  http://nyatla.jp/mimic/wp/
 *
 * 2013.7.11 : Following original update.
 *
 */

#include "mbed.h"
#include "SDFileSystem.h"
#include "mimic.h"
#include "utils/PlatformInfo.h"

#define URL_HANDLE 1 /* if you use TEST URL HANDLER */

DigitalOut LED_1(P3_25),LED_2(P3_26);
Serial pc(P0_2,P0_3) ;

/**
 * sd filesystem support.
 */
SDFileSystem sd(P1_24, P1_23, P1_20, P1_21,"sd");
unsigned int p = 0; // LED TOGGLE COUNTER

/**
 * MiMic RemoteMCU httpd.<br/>
 * Number of simultaneous connections:4
 * <p>Service list</p>
 * <pre>
 * /sd/  - mbed LocalFileSystem
 * /**** - URL Handler for test
 * </pre>
 */
class FsHttpd:public MiMic::Httpd
{
private:
    ModUrl modurl; //basic URL parser
    ModLocalFileSystem modsd;
public:
    FsHttpd(NetConfig& i_cfg):Httpd(i_cfg._inst.services.http_port)
    {
        //bind local file system path to /local/*
        modsd.setParam("sd");
    }
    virtual void onRequest(HttpdConnection& i_connection)
    {
        p++;
        LED_1 = p%2;
        
        //try to ModLocalFileSystem(SD)
        if(this->modsd.execute(i_connection)){
            return;
        }
        
#ifdef URL_HANDLE
        // URL 
        char url[32];
        int method;
        if(this->modurl.execute(i_connection,url,32,&method)){
            //send 200 OK and requested URL
            i_connection.sendHeader(200,"text/html",NULL);
            i_connection.sendBodyF("Your Request No is [%d] , path is %s.",p,url);
            pc.printf("%s\r\n",url) ;
            return;
        }
#endif

        //Otherwise, Send simple top index page.
        i_connection.sendHeader(200,"text/html",NULL);
        if(i_connection.isMethodType(Http::MT_GET)){
            i_connection.sendBodyF(
                "<!DOCTYPE html>"
                "<html lang=\"ja\">"  
                "<head></head>"
                "<body>"
                "<h1>This is MiMic Server : Mini1768DK2 Port.</h1>"
                "<hr/>"
                "<ul>"
                "<li><a href=\"/sd/\">SDCard</a></li>"
                "</ul></body>");
        }
    }
};

NetConfig cfg; //create network configulation
int main()
{
    Net net;  //create a net instance.
    pc.baud(9600) ; // serial port for debug

    //try to override setting by SD file.
    if (cfg.loadFromFile("/sd/mimic.cfg")) {
        pc.printf("Setting is Overridden by /sd/mimic.cfg\r\n") ;
    } else {
        pc.printf("MY ADDR is 192.168.1.239\r\n") ;
        cfg.setEmac(0x1,0x2,0x3,0x4,0x5,0x6);
        cfg.setIpAddr(192,168,1,239) ;
        cfg.setGateway(192,168,1,1) ;
        cfg.setNetMask(255,255,255,0) ;
    }

    FsHttpd httpd(cfg); //create a httpd instance.
    net.start(cfg);
    httpd.loop();  //start httpd loop.
    return 0;
}
