/*AD9834 DDS Test 2011/07/14 MLabo*/
/*AD9832 DDS Test based on 2011/07/14 MLabo, by Fuyuno,Sakura */
/*AD5235 DPM Test based on AD9832 DDS Test by Fuyuno,Sakura */
/*AD5235 DPM and AD9832 DDS Test by Fuyuno,Sakura */
#include "mbed.h"

// Signal pair(SCLK:SCLKD,SDATA:SDI) may share same pins....
// Usage : 38400bps 8N1 , '*' cmd is change control target

// SPI for DPM
DigitalOut CS(p8);
DigitalOut SCLK(p7);
DigitalOut SDI(p5);

// SPI for DDS
DigitalOut FSYN(p14);
DigitalOut SCLKD(p13);
DigitalOut SDATA(p11);

Serial pc(USBTX,USBRX);

#define XTAL_FREQ ((double)16160000.0)

void serial_out(uint16_t data) {
    FSYN = 0;
    data & 0x8000? SDATA = 1 : SDATA = 0; SCLKD = 0; SCLKD = 1;
    data & 0x4000? SDATA = 1 : SDATA = 0; SCLKD = 0; SCLKD = 1;
    data & 0x2000? SDATA = 1 : SDATA = 0; SCLKD = 0; SCLKD = 1;
    data & 0x1000? SDATA = 1 : SDATA = 0; SCLKD = 0; SCLKD = 1;
    data & 0x0800? SDATA = 1 : SDATA = 0; SCLKD = 0; SCLKD = 1;
    data & 0x0400? SDATA = 1 : SDATA = 0; SCLKD = 0; SCLKD = 1;
    data & 0x0200? SDATA = 1 : SDATA = 0; SCLKD = 0; SCLKD = 1;
    data & 0x0100? SDATA = 1 : SDATA = 0; SCLKD = 0; SCLKD = 1;
    data & 0x0080? SDATA = 1 : SDATA = 0; SCLKD = 0; SCLKD = 1;
    data & 0x0040? SDATA = 1 : SDATA = 0; SCLKD = 0; SCLKD = 1;
    data & 0x0020? SDATA = 1 : SDATA = 0; SCLKD = 0; SCLKD = 1;
    data & 0x0010? SDATA = 1 : SDATA = 0; SCLKD = 0; SCLKD = 1;
    data & 0x0008? SDATA = 1 : SDATA = 0; SCLKD = 0; SCLKD = 1;
    data & 0x0004? SDATA = 1 : SDATA = 0; SCLKD = 0; SCLKD = 1;
    data & 0x0002? SDATA = 1 : SDATA = 0; SCLKD = 0; SCLKD = 1;
    data & 0x0001? SDATA = 1 : SDATA = 0; SCLKD = 0; SCLKD = 1;
    FSYN = 1;
}

typedef union {
    uint32_t        UI;
    uint8_t        B[4];
} FREQDATA ;

void AD9832_Init(void) {
    FREQDATA FreqReg ;
    FreqReg.UI = 0 ;
    serial_out(0xF800);
    serial_out(0x3300 + FreqReg.B[3]);
    serial_out(0x2200 + FreqReg.B[2]);        
    serial_out(0x3100 + FreqReg.B[1]);
    serial_out(0x2000 + FreqReg.B[0]);
    serial_out(0xC000);
}

void AD9832_SetFreq(double freq) {
    FREQDATA FreqReg ;
    FreqReg.UI = (uint32_t)(freq * (double)(0x100000000UL) / (XTAL_FREQ) + 0.5);
    serial_out(0x3300 + FreqReg.B[3]);
    serial_out(0x2200 + FreqReg.B[2]);        
    serial_out(0x3100 + FreqReg.B[1]);
    serial_out(0x2000 + FreqReg.B[0]);
}

void serial_out24(uint32_t data) {
    CS = 0;
    data & 0x800000? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x400000? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x200000? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x100000? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x080000? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x040000? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x020000? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x010000? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x008000? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x004000? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x002000? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x001000? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x000800? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x000400? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x000200? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x000100? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x000080? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x000040? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x000020? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x000010? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x000008? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x000004? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x000002? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    data & 0x000001? SDI = 1 : SDI = 0; SCLK = 0; SCLK = 1;
    CS = 1;
}

// Writes data X to the RDAC1 register,
void AD5235_SET(int chan,int value) {
    uint32_t cmd ;
    cmd = 0xB00000 | ((chan == 1) ?  0x010000 : 0x000000) | (value & 0x03FF) ;
    serial_out24(cmd);
}

void AD5235_SAVE(int chan) {
    uint32_t cmd ;
    cmd = 0x200000 | ((chan == 1) ?  0x010000 : 0x000000) ;
    serial_out24(cmd);
}

int main() {
    double freq = 60.0;
    int val ;
    char buf[256] ;
    int i,ptr ;
    
    int chan = 1 ;
    
    pc.baud(38400);
    SCLK = 1;
    SDI  = 0;
    CS  = 1;
    
    SCLKD = 1;
    SDATA = 0;
    FSYN = 1;

    AD9832_Init();
    AD9832_SetFreq(freq) ;
    while(1) {
        while (1) {
            pc.printf("\r\nAD5235>");
            ptr = 0;
            while(1) {
                if (pc.readable()) {
                    i = pc.getc() ;
                    if (i == 0x0D) {
                        buf[ptr] = '\0' ;
                        break ;
                    }
                    pc.putc(i) ;
                    buf[ptr++] = i ;
                }
            }
            if (buf[0] == '*') break ;
            val = atoi(buf) ;
            AD5235_SET(chan,val) ;
            //AD5235_SAVE(chan) ;
            pc.printf("\r\nRVAL SET to Chan %d to %04X",chan,val);        
        }
        while(1) {
            pc.printf("\r\nAD9832>");
            ptr = 0;
            while(1) {
                if (pc.readable()) {
                    i = pc.getc() ;
                    if (i == 0x0D) {
                        buf[ptr] = '\0' ;
                        break ;
                    }
                    pc.putc(i) ;
                    buf[ptr++] = i ;
                }
            }
            if (buf[0] == '*') break ;
            freq = atof(buf) ;
            pc.printf("\r\nFreq SET:%g",freq);        
            AD9832_SetFreq(freq) ;
        }
    }
}
