/*AD9834 DDS Test 2011/07/14 MLabo*/
/*AD9832 DDS Test based on 2011/07/14 MLabo, by Sakura,Fuyuno */
#include "mbed.h"

#define XTAL_FREQ ((double)16160000.0)

DigitalOut FSYN(p8);
DigitalOut SCLK(p7);
DigitalOut SDATA(p5);
Serial pc(USBTX,USBRX);

void serial_out(uint16_t data) {
    FSYN = 0;
    data & 0x8000? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x4000? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x2000? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x1000? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0800? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0400? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0200? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0100? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0080? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0040? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0020? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0010? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0008? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0004? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0002? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0001? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    FSYN = 1;
}

typedef union {
    uint32_t        UI;
    uint8_t        B[4];
} FREQDATA ;

void AD9832_Init(void) {
    FREQDATA FreqReg ;
    FreqReg.UI = 0 ;
    serial_out(0xF800);
    serial_out(0x3300 + FreqReg.B[3]);
    serial_out(0x2200 + FreqReg.B[2]);        
    serial_out(0x3100 + FreqReg.B[1]);
    serial_out(0x2000 + FreqReg.B[0]);
    serial_out(0xC000);
}

void AD9832_SetFreq(double freq) {
    FREQDATA FreqReg ;
    FreqReg.UI = (uint32_t)(freq * (double)(0x100000000UL) / (XTAL_FREQ) + 0.5);
    serial_out(0x3300 + FreqReg.B[3]);
    serial_out(0x2200 + FreqReg.B[2]);        
    serial_out(0x3100 + FreqReg.B[1]);
    serial_out(0x2000 + FreqReg.B[0]);
}

int main() {
    double freq ;
    char buf[256] ;
    int i,ptr ;
    
    pc.baud(38400);
    SCLK = 1;
    SDATA = 0;
    FSYN = 1;
    AD9832_Init();
    AD9832_SetFreq(60.0) ;
    while(1) {
        pc.printf("\r\nAD9832>");
        ptr = 0;
        while(1) {
            if (pc.readable()) {
                i = pc.getc() ;
                if (i == 0x0D) {
                    buf[ptr] = '\0' ;
                    break ;
                }
                pc.putc(i) ;
                buf[ptr++] = i ;
            }
        }
        freq = atof(buf) ;
        pc.printf("\r\nFreq SET:%g",freq);        
        AD9832_SetFreq(freq) ;
    }
}
