#include "mbed.h"
#include "coroutine.h"

volatile uint16_t cr_time1;
volatile uint16_t cr_time2;

void user_thread1(void);
void user_thread2(void);

Ticker toggle_led_ticker;
DigitalOut led1(LED1);
DigitalOut led2(LED2);

void isr_ticker() {
    cr_time1++;
    cr_time2++;
}



int main(void) {
    // Init the ticker with the address of the function (isr_ticker) to be attached and the interval (1 ms)
    toggle_led_ticker.attach(&isr_ticker, 0.001);
    while (true) {
        // Do other things...
        user_thread1();
        user_thread2();
    }
}

void user_thread1(void)
{
    cr_start();
    
    // inital once each loop
    cr_time1 = 0;
    // waiting for condition is satisfied, or will be yield
    cr_yield(cr_time1 != 1000);
    led1 = !led1;
            
    cr_end();
}

void user_thread2(void)
{
    cr_start();
    
    // inital once each loop
    cr_time2 = 0;
    // waiting for condition is satisfied, or will be yield
    cr_yield(cr_time2 != 800);
    led2 = !led2;

    cr_end();           
}
