#include "mbed.h"

//------------------------------------
// USER_KEY-PB_3 / USER_BUTTON-PC_13
//------------------------------------
InterruptIn mybutton(PB_3);
//------------------------------------
// LED1-PA5
//------------------------------------
DigitalOut myled(PA_5);
//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
// SERIAL_TX-PA2, SERIAL_RX-PA3
//------------------------------------
Serial pc(PA_2, PA_3);

Timeout flipper;

#define entry()    pc.printf("func:%s\n", __FUNCTION__)

#define error()    pc.printf("Error! func:%s, line: %d\n", __FUNCTION__, __LINE__)

enum{OFF=0,ON=1};
enum{PRESS= 0, RELEASE = 1, UNKNOWN};
#define PRESS_JITTER_TIME       0.01    // 10ms
#define RELEASE_JITTER_TIME     0.02    // 20ms
uint8_t cur_flag_status = UNKNOWN;
uint8_t pre_flag_status = UNKNOWN;

void update_key_status(void)
{
    pre_flag_status = cur_flag_status;
    cur_flag_status = mybutton.read();
}

void key_down_status(void)
{
    update_key_status();
    if(cur_flag_status == PRESS){
        if(myled.read()!=ON){
           if(pre_flag_status == PRESS){
                myled = ON;
                pc.printf("Pressed\n");
           }
        }
    }
}

void key_up_status(void)
{
    update_key_status();
    if(cur_flag_status == RELEASE){
        if(myled.read()!=OFF){
            if(pre_flag_status == RELEASE){
                myled = OFF;
                pc.printf("Released\n");
           }
        }
    }
}

void double_check(void)
{
    //entry();
    switch(cur_flag_status){
    case PRESS:
        key_down_status();
       break;
    case RELEASE:
        key_up_status();
       break;
    default:
        error();
       break;
    }
}

void pressed(void)
{
    //entry();
    if(myled.read()!=ON){
        cur_flag_status = PRESS;
        // double ckeck for press status
        flipper.attach(&double_check, PRESS_JITTER_TIME);
    }
}

void released(void)
{
    //entry();
    if(myled.read()!=OFF){
        cur_flag_status = RELEASE;
        // double check for releasse status
        flipper.attach(&double_check, RELEASE_JITTER_TIME);
    }
}


/* 
 *  fall edge & timout interrupt for down check;
 *  rise edge & timout interrupt for up check.
 */
int main(void)
{
    myled = OFF;
    mybutton.fall(&pressed);
    mybutton.rise(&released);
    while(1) {
        // extend more task here
    }
}