#include "mbed.h"

//------------------------------------
// USER_KEY-PB_3 / USER_BUTTON-PC_13
//------------------------------------
DigitalIn mybutton(PB_3);
//------------------------------------
// LED1-PA5
//------------------------------------
DigitalOut myled(PA_5);
//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
// SERIAL_TX-PA2, SERIAL_RX-PA3
//------------------------------------
Serial pc(PA_2, PA_3);

Ticker jitter_down, jitter_up;

#define entry()    pc.printf("func:%s\n", __FUNCTION__)

#define error()    pc.printf("Error! func:%s, line: %d\n", __FUNCTION__, __LINE__)

enum{OFF=0,ON=1};
enum{PRESS= 0, RELEASE = 1, UNKNOWN};
#define PRESS_JITTER_TIME       0.01    // 10ms
#define RELEASE_JITTER_TIME     0.02    // 20ms
uint8_t cur_flag_status = UNKNOWN;
uint8_t pre_flag_status = UNKNOWN;

void update_key_status(void)
{
    pre_flag_status = cur_flag_status;
    cur_flag_status = mybutton.read();
}

void key_down_status(void)
{
    update_key_status();
    if(cur_flag_status == PRESS){
        if(myled.read()!=ON){
           if(pre_flag_status == PRESS){
                myled = ON;
                pc.printf("Pressed\n");
           }
        }
    }
}

void key_up_status(void)
{
    update_key_status();
    if(cur_flag_status == RELEASE){
        if(myled.read()!=OFF){
            if(pre_flag_status == RELEASE){
                myled = OFF;
                pc.printf("Released\n");
           }
        }
    }
}

/* 
 *  ticker down for down check;
 *  ticker down for up check.
 */
int main(void)
{
    myled = OFF;
    jitter_down.attach(&key_down_status, PRESS_JITTER_TIME);
    jitter_up.attach(&key_up_status, RELEASE_JITTER_TIME);
    while(1) {
        // extend more task here
    }
}