#ifndef COROUTINE_H_
#define COROUTINE_H_

#ifdef __cplushplus
extern "C"{
#endif

/**
 * C coroutine 
 * https://github.com/mintisan/mintisan.github.io/wiki/C#coroutine
 */

#define cr_start()              \
        static int __s = 0;     \
        switch(__s){            \
            case 0:

// '\' doesn't count for one line in C
#define cr_yield(condition) do{      \
            __s = __LINE__ ;     \
                case __LINE__:      \
                    if(condition)   \
                    return;         \
                }while(0)

#define cr_end()                \
        } __s = 0;            


#ifdef __cplushplus
}
#endif

#endif
