#include "mbed.h"
#include "rtos.h"

#include "DS1820.h"
#define DATA_PIN D12 
 
DS1820 probe(DATA_PIN);  /*on the DATA_PIN (a 4.7K resistor tp VCC is necessary)*/
DigitalOut led1(LED1);

void thread_print();
void thread_led();
void thread_ds1820();

Thread thread1,thread2,thread3;
// main() runs in its own thread in the OS
int main() {
    thread1.start(thread_print);
    thread2.start(thread_led);
    thread3.start(thread_ds1820);
    while(1)
    {
        printf("10 sec pass...\n");
        Thread::wait(10000);
    }
}

void thread_print()
{
    while(true){
        printf("Ich liebe dich!\n");
        Thread::wait(2000);   //2000ms
    }
}

void thread_led()
{
    while (true) {
        led1 = !led1;
        Thread::wait(1000);  //1000 ms
    }
}

void thread_ds1820()
{
    // Initialize the probe array to DS1820 objects
    DS1820::unassignedProbe(DATA_PIN);
    float celsius, fahrenheit;

    printf("A simple DS1820 Test:\r\n");
    while(1) {
        probe.convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
        celsius = probe.temperature();
        fahrenheit = celsius * 1.8f + 32.0f;
        printf("Temperture = %.1f celsius, %.1f fahrenheit.\r\n",celsius, fahrenheit);
        Thread::wait(1000);
    }
}