#include "mbed.h"
#include "DS1820.h"
#define DATA_PIN D12 
/*on the DATA_PIN (a 4.7K resistor tp VCC is necessary)*/
 
DS1820 probe(DATA_PIN);
 
int main() {  
    // Initialize the probe array to DS1820 objects
    DS1820::unassignedProbe(DATA_PIN);
    float celsius, fahrenheit;

    printf("A simple DS1820 Test:\r\n");
    while(1) {
        probe.convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
        celsius = probe.temperature();
        fahrenheit = celsius * 1.8f + 32.0f;
        printf("Temperture = %.1f celsius, %.1f fahrenheit.\r\n",celsius, fahrenheit);
        wait(1);
    }
    
}
