#include "mbed.h"

// create PWM objects for leds
PwmOut led1(LED1),led2(LED2),led3(LED3),led4(LED4);

// start que
float a=0.25f,b=0,c=-0.25f,d=-0.5f;

// init down or uplight
int aa=0,bb=0,cc=0,dd=0;

void blinky(int &dir,float &val){
    if (val>=0.5){
        dir=1;
    } else if (val<-1) {
        dir=0;
    }
    
    if (dir==0) {
        val+=0.025f;
    } else {
        val-=0.025f;
    };
}

int globaldir=0;
int cnt=0;
int main() {
    while (1) {
        // Toggle directions every 3rd cycle
        if ((!aa && d<-1) || (!dd && a<-1)) {
            cnt+=1;
            if ( cnt>(3-1) ) {
                cnt=0;
                if (!globaldir) {
                    d=0.00f,c=-0.25f,b=-0.50f,a=-0.75f;
                } else {
                    a=0.00f,b=-0.25f,c=-0.50f,d=-0.75f;
                }
                aa=0,bb=0,cc=0,dd=0;
                globaldir=(!globaldir);
            }
        }
        
        // calc led-values
        blinky(aa,a);
        blinky(bb,b);
        blinky(cc,c);
        blinky(dd,d);
        
        // set leds
        led1 = a;
        led2 = b;
        led3 = c;
        led4 = d;

        wait(0.010);
    }
}
