#include "mbed.h"

Serial pc(USBTX, USBRX, 9600);

PwmOut pwm1(A1);
PwmOut pwm2(A3);
//AnalogOut out1(A2); //NE KORISTI SE

//Pressure Temp SENSOR 1
AnalogIn sensor1Pressure(PC_0);
AnalogIn sensor1Temperature(PC_1);
//Pressure Temp SENSOR 2
AnalogIn sensor2Pressure(PA_6);
AnalogIn sensor2Temperature(PA_7);

int main()
{
    pwm1.write(0.5);
    pwm2.write(0.5);

    pwm1.period_ms(10);
    pwm2.period_ms(10);
    
    //out1.write(0.5f);

    while(1) {
        
        float sensor1InVal = ((sensor1Pressure.read() * 3.3f) - 0.5f) / 0.004f;
        
        pc.printf("\n- - - SENSOR1 - - -\n");
        pc.printf("Pressure: %.2f Bar\n",sensor1InVal/100);
        
        float V1 = sensor1Temperature.read()*3.3f;
        float R1 = (4700*V1)/(5-V1);
        double a1 = 3.90917*pow((double)10,(double)-14);
        double T1 = -137.6209 + (74326.73 + 137.6209)/pow((double)(1 + (R1/a1)), (double)0.1591221);

        pc.printf("Temp: %3.2fC\n\n", T1);        
        
        float sensor2InVal = ((sensor2Pressure.read() * 3.3f) - 0.5f) / 0.004f;
        pc.printf("- - - SENSOR2 - - -\n");
        pc.printf("Pressure: %.2f Bar\n",sensor2InVal/100);

        float V2 = sensor2Temperature.read()*3.3f;
        float R2 = (4700*V2)/(5-V2);
        double a2 = 3.90917*pow((double)10,(double)-14);
        double T2 = -137.6209 + (74326.73 + 137.6209)/pow((double)(1 + (R2/a2)), (double)0.1591221);

        pc.printf("Temp: %3.2fC\n\n", T2);
        wait(1);
    }
}